/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.hooks.fluid.FluidBucketHooks;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.common.plugins.REICommonPlugin;
import me.shedaniel.rei.api.common.registry.display.ServerDisplayRegistry;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.client.categories.crafting.filler.ArmorDyeRecipeFiller;
import me.shedaniel.rei.plugin.client.categories.crafting.filler.BannerDuplicateRecipeFiller;
import me.shedaniel.rei.plugin.client.categories.crafting.filler.BookCloningRecipeFiller;
import me.shedaniel.rei.plugin.client.categories.crafting.filler.CraftingRecipeFiller;
import me.shedaniel.rei.plugin.client.categories.crafting.filler.FireworkRocketRecipeFiller;
import me.shedaniel.rei.plugin.client.categories.crafting.filler.MapCloningRecipeFiller;
import me.shedaniel.rei.plugin.client.categories.crafting.filler.MapExtendingRecipeFiller;
import me.shedaniel.rei.plugin.client.categories.crafting.filler.ShieldDecorationRecipeFiller;
import me.shedaniel.rei.plugin.client.categories.crafting.filler.TippedArrowRecipeFiller;
import me.shedaniel.rei.plugin.client.displays.ClientsidedCookingDisplay;
import me.shedaniel.rei.plugin.client.displays.ClientsidedCraftingDisplay;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.DefaultCampfireDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultCompostingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultFuelDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultInformationDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultOxidationScrapingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultOxidizingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultPathingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultSmithingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultStoneCuttingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultStrippingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultTillingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultWaxScrapingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultWaxingDisplay;
import me.shedaniel.rei.plugin.common.displays.anvil.DefaultAnvilDisplay;
import me.shedaniel.rei.plugin.common.displays.beacon.DefaultBeaconBaseDisplay;
import me.shedaniel.rei.plugin.common.displays.beacon.DefaultBeaconPaymentDisplay;
import me.shedaniel.rei.plugin.common.displays.brewing.DefaultBrewingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultBlastingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultSmeltingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultSmokingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomShapedDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomShapelessDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultShapedDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultShapelessDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.MapExtendingCraftingDisplay;
import me.shedaniel.rei.plugin.common.displays.tag.TagNodes;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class DefaultPlugin
implements BuiltinPlugin,
REICommonPlugin {
    private static final CraftingRecipeFiller<?>[] CRAFTING_RECIPE_FILLERS = new CraftingRecipeFiller[]{new TippedArrowRecipeFiller(), new BannerDuplicateRecipeFiller(), new ShieldDecorationRecipeFiller(), new BookCloningRecipeFiller(), new FireworkRocketRecipeFiller(), new ArmorDyeRecipeFiller(), new MapCloningRecipeFiller(), new MapExtendingRecipeFiller()};

    public void registerItemComparators(ItemComparatorRegistry registry) {
        Function<ItemStack, ItemEnchantments> enchantmentTag = stack -> {
            if (stack.has(DataComponents.STORED_ENCHANTMENTS)) {
                return (ItemEnchantments)stack.get(DataComponents.STORED_ENCHANTMENTS);
            }
            return (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        };
        registry.register((context, stack) -> Objects.hashCode(enchantmentTag.apply((ItemStack)stack)), (Object)Items.ENCHANTED_BOOK);
        registry.registerComponents(Items.POTION);
        registry.registerComponents(Items.SPLASH_POTION);
        registry.registerComponents(Items.LINGERING_POTION);
        registry.registerComponents(Items.TIPPED_ARROW);
        registry.register((context, stack) -> 0L, (Object[])new Item[]{Items.FIREWORK_ROCKET, Items.FILLED_MAP});
    }

    public void registerFluidSupport(FluidSupportProvider support) {
        support.register(entry -> {
            BucketItem bucketItem;
            Fluid fluid;
            ItemStack stack = (ItemStack)entry.getValue();
            Item item = stack.getItem();
            if (item instanceof BucketItem && (fluid = FluidBucketHooks.getFluid((BucketItem)(bucketItem = (BucketItem)item))) != null) {
                return CompoundEventResult.interruptTrue(Stream.of(EntryStacks.of((Fluid)fluid, (long)FluidStackHooks.bucketAmount())));
            }
            return CompoundEventResult.pass();
        });
    }

    public void registerDisplays(ServerDisplayRegistry registry) {
        registry.beginRecipeFiller(CraftingRecipe.class).filterType(RecipeType.CRAFTING).fill(DefaultCraftingDisplay::of);
        registry.beginRecipeFiller(SmeltingRecipe.class).filterType(RecipeType.SMELTING).fill(DefaultSmeltingDisplay::new);
        registry.beginRecipeFiller(SmokingRecipe.class).filterType(RecipeType.SMOKING).fill(DefaultSmokingDisplay::new);
        registry.beginRecipeFiller(BlastingRecipe.class).filterType(RecipeType.BLASTING).fill(DefaultBlastingDisplay::new);
        registry.beginRecipeFiller(CampfireCookingRecipe.class).filterType(RecipeType.CAMPFIRE_COOKING).fill(DefaultCampfireDisplay::new);
        registry.beginRecipeFiller(StonecutterRecipe.class).filterType(RecipeType.STONECUTTING).fill(DefaultStoneCuttingDisplay::new);
        registry.beginRecipeFiller(SmithingTransformRecipe.class).filterType(RecipeType.SMITHING).fill(DefaultSmithingDisplay::ofTransforming);
        registry.beginRecipeFiller(SmithingTrimRecipe.class).filterType(RecipeType.SMITHING).fillMultiple(DefaultSmithingDisplay::fromTrimming);
        for (CraftingRecipeFiller<?> filler : CRAFTING_RECIPE_FILLERS) {
            filler.registerDisplays(registry);
        }
    }

    public void registerDisplaySerializer(DisplaySerializerRegistry registry) {
        registry.register(DefaultPlugin.id("client/crafting/shaped"), ClientsidedCraftingDisplay.Shaped.SERIALIZER);
        registry.register(DefaultPlugin.id("client/crafting/shapeless"), ClientsidedCraftingDisplay.Shapeless.SERIALIZER);
        registry.register(DefaultPlugin.id("client/smelting"), ClientsidedCookingDisplay.Smelting.SERIALIZER);
        registry.register(DefaultPlugin.id("client/smoking"), ClientsidedCookingDisplay.Smoking.SERIALIZER);
        registry.register(DefaultPlugin.id("client/blasting"), ClientsidedCookingDisplay.Blasting.SERIALIZER);
        registry.register(DefaultPlugin.id("default/crafting/shaped"), DefaultShapedDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/crafting/shapeless"), DefaultShapelessDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/crafting/custom"), DefaultCustomDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/crafting/custom_shaped"), DefaultCustomShapedDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/crafting/custom_shapeless"), DefaultCustomShapelessDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("extension/crafting/map_extending"), MapExtendingCraftingDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/smelting"), DefaultSmeltingDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/smoking"), DefaultSmokingDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/blasting"), DefaultBlastingDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/campfire"), DefaultCampfireDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/stone_cutting"), DefaultStoneCuttingDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/stripping"), DefaultStrippingDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/brewing"), DefaultBrewingDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/composting"), DefaultCompostingDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/fuel"), DefaultFuelDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/smithing"), DefaultSmithingDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/smithing/trimming"), DefaultSmithingDisplay.Trimming.SERIALIZER);
        registry.register(DefaultPlugin.id("default/anvil"), DefaultAnvilDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/beacon_base"), DefaultBeaconBaseDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/beacon_payment"), DefaultBeaconPaymentDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/tilling"), DefaultTillingDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/pathing"), DefaultPathingDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/waxing"), DefaultWaxingDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/waxing_scraping"), DefaultWaxScrapingDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/oxidizing"), DefaultOxidizingDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("default/oxidizing_scraping"), DefaultOxidationScrapingDisplay.SERIALIZER);
        registry.register(DefaultPlugin.id("roughlyenoughitems:default/information"), DefaultInformationDisplay.SERIALIZER);
    }

    public double getPriority() {
        return -100.0;
    }

    private static Identifier id(String path) {
        return Identifier.parse((String)path);
    }

    static {
        TagNodes.init();
    }
}

