/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.gson.internal.LinkedTreeMap;
import dev.architectury.event.EventResult;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZonesProvider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.plugin.autocrafting.InventoryCraftingTransferHandler;
import me.shedaniel.rei.plugin.autocrafting.recipebook.DefaultRecipeBookHandler;
import me.shedaniel.rei.plugin.client.BuiltinClientPlugin;
import me.shedaniel.rei.plugin.client.categories.DefaultBrewingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultCampfireCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultCompostingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultFuelCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultInformationCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultOxidationScrapingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultOxidizingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultPathingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultSmithingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultStoneCuttingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultStrippingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultTillingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultWaxScrapingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultWaxingCategory;
import me.shedaniel.rei.plugin.client.categories.anvil.DefaultAnvilCategory;
import me.shedaniel.rei.plugin.client.categories.beacon.DefaultBeaconBaseCategory;
import me.shedaniel.rei.plugin.client.categories.beacon.DefaultBeaconPaymentCategory;
import me.shedaniel.rei.plugin.client.categories.cooking.DefaultCookingCategory;
import me.shedaniel.rei.plugin.client.categories.crafting.DefaultCraftingCategory;
import me.shedaniel.rei.plugin.client.categories.tag.DefaultTagCategory;
import me.shedaniel.rei.plugin.client.displays.ClientsidedCookingDisplay;
import me.shedaniel.rei.plugin.client.displays.ClientsidedCraftingDisplay;
import me.shedaniel.rei.plugin.client.exclusionzones.DefaultPotionEffectExclusionZones;
import me.shedaniel.rei.plugin.client.exclusionzones.DefaultRecipeBookExclusionZones;
import me.shedaniel.rei.plugin.client.favorites.GameModeFavoriteEntry;
import me.shedaniel.rei.plugin.client.favorites.TimeFavoriteEntry;
import me.shedaniel.rei.plugin.client.favorites.WeatherFavoriteEntry;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.DefaultCompostingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultInformationDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultOxidationScrapingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultOxidizingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultPathingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultStrippingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultWaxScrapingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultWaxingDisplay;
import me.shedaniel.rei.plugin.common.displays.anvil.AnvilRecipe;
import me.shedaniel.rei.plugin.common.displays.anvil.DefaultAnvilDisplay;
import me.shedaniel.rei.plugin.common.displays.beacon.DefaultBeaconBaseDisplay;
import me.shedaniel.rei.plugin.common.displays.beacon.DefaultBeaconPaymentDisplay;
import me.shedaniel.rei.plugin.common.displays.brewing.BrewingRecipe;
import me.shedaniel.rei.plugin.common.displays.brewing.DefaultBrewingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.CookingDisplay;
import me.shedaniel.rei.plugin.common.displays.tag.DefaultTagDisplay;
import me.shedaniel.rei.plugin.common.displays.tag.TagNodes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.BlastFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.BrewingStandScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.FurnaceScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.SmokerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.BlastFurnaceMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.FurnaceMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.SmokerMenu;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.display.FurnaceRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
@ApiStatus.Internal
public class DefaultClientPlugin
implements REIClientPlugin,
BuiltinClientPlugin {
    public DefaultClientPlugin() {
        ClientInternals.attachInstance(() -> this, (String)"builtinClientPlugin");
    }

    @Override
    public void registerBrewingRecipe(EntryIngredient input, EntryIngredient ingredient, EntryIngredient output) {
        DisplayRegistry.getInstance().add((Object)new BrewingRecipe(input, ingredient, output));
    }

    @Override
    public void registerInformation(EntryIngredient ingredient, Component name, UnaryOperator<List<Component>> textBuilder) {
        DisplayRegistry.getInstance().add((Display)DefaultInformationDisplay.createFromEntries(ingredient, name).lines((Collection)textBuilder.apply(Lists.newArrayList())));
    }

    public void registerEntries(EntryRegistry registry) {
        ListMultimap items = Multimaps.newListMultimap((Map)new Reference2ObjectOpenHashMap(), ArrayList::new);
        for (Map.Entry<CreativeModeTab, Collection<ItemStack>> entry : DefaultClientPlugin.collectTabs().entrySet()) {
            try {
                for (ItemStack stack : entry.getValue()) {
                    try {
                        items.put((Object)stack.getItem(), (Object)EntryStacks.of((ItemStack)stack));
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        for (Item item : BuiltInRegistries.ITEM) {
            Collection stacks = items.get((Object)item);
            if (stacks.isEmpty()) {
                try {
                    registry.addEntry(EntryStacks.of((ItemStack)item.getDefaultInstance()));
                }
                catch (Exception ignore) {
                    registry.addEntry(EntryStacks.of((ItemLike)item));
                }
                continue;
            }
            registry.addEntries(stacks);
        }
        for (Fluid fluid : BuiltInRegistries.FLUID) {
            FluidState state = fluid.defaultFluidState();
            if (state.isEmpty() || !state.isSource()) continue;
            registry.addEntry(EntryStacks.of((Fluid)fluid));
        }
    }

    private static Map<CreativeModeTab, Collection<ItemStack>> collectTabs() {
        try {
            return (Map)Class.forName(Platform.isForge() ? "me.shedaniel.rei.impl.client.forge.CreativeModeTabCollectorImpl" : "me.shedaniel.rei.impl.client.fabric.CreativeModeTabCollectorImpl").getDeclaredMethod("collectTabs", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerCollapsibleEntries(CollapsibleEntryRegistry registry) {
        registry.group(Identifier.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"enchanted_book"), (Component)Component.translatable((String)"item.minecraft.enchanted_book"), stack -> stack.getType() == VanillaEntryTypes.ITEM && ((ItemStack)stack.castValue()).is(Items.ENCHANTED_BOOK));
        registry.group(Identifier.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"potion"), (Component)Component.translatable((String)"item.minecraft.potion"), stack -> stack.getType() == VanillaEntryTypes.ITEM && ((ItemStack)stack.castValue()).is(Items.POTION));
        registry.group(Identifier.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"splash_potion"), (Component)Component.translatable((String)"item.minecraft.splash_potion"), stack -> stack.getType() == VanillaEntryTypes.ITEM && ((ItemStack)stack.castValue()).is(Items.SPLASH_POTION));
        registry.group(Identifier.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"lingering_potion"), (Component)Component.translatable((String)"item.minecraft.lingering_potion"), stack -> stack.getType() == VanillaEntryTypes.ITEM && ((ItemStack)stack.castValue()).is(Items.LINGERING_POTION));
        registry.group(Identifier.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"spawn_egg"), (Component)Component.translatable((String)"text.rei.spawn_egg"), stack -> stack.getType() == VanillaEntryTypes.ITEM && ((ItemStack)stack.castValue()).getItem() instanceof SpawnEggItem);
        registry.group(Identifier.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"tipped_arrow"), (Component)Component.translatable((String)"item.minecraft.tipped_arrow"), stack -> stack.getType() == VanillaEntryTypes.ITEM && ((ItemStack)stack.castValue()).is(Items.TIPPED_ARROW));
        registry.group(Identifier.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"music_disc"), (Component)Component.translatable((String)"text.rei.music_disc"), stack -> stack.getType() == VanillaEntryTypes.ITEM && ((ItemStack)stack.castValue()).has(DataComponents.JUKEBOX_PLAYABLE));
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.add(new DisplayCategory[]{new DefaultCraftingCategory(), new DefaultCookingCategory((CategoryIdentifier<? extends CookingDisplay>)SMELTING, EntryStacks.of((ItemLike)Items.FURNACE), "category.rei.smelting", 200.0), new DefaultCookingCategory((CategoryIdentifier<? extends CookingDisplay>)SMOKING, EntryStacks.of((ItemLike)Items.SMOKER), "category.rei.smoking", 100.0), new DefaultCookingCategory((CategoryIdentifier<? extends CookingDisplay>)BLASTING, EntryStacks.of((ItemLike)Items.BLAST_FURNACE), "category.rei.blasting", 100.0), new DefaultCampfireCategory(), new DefaultStoneCuttingCategory(), new DefaultFuelCategory(), new DefaultBrewingCategory(), new DefaultCompostingCategory(), new DefaultStrippingCategory(), new DefaultSmithingCategory(), new DefaultAnvilCategory(), new DefaultBeaconBaseCategory(), new DefaultBeaconPaymentCategory(), new DefaultTillingCategory(), new DefaultPathingCategory(), new DefaultWaxingCategory(), new DefaultWaxScrapingCategory(), new DefaultOxidizingCategory(), new DefaultOxidationScrapingCategory()});
        registry.addWorkstations(CRAFTING, new EntryStack[]{EntryStacks.of((ItemLike)Items.CRAFTING_TABLE)});
        registry.addWorkstations(SMELTING, new EntryStack[]{EntryStacks.of((ItemLike)Items.FURNACE)});
        registry.addWorkstations(SMOKING, new EntryStack[]{EntryStacks.of((ItemLike)Items.SMOKER)});
        registry.addWorkstations(BLASTING, new EntryStack[]{EntryStacks.of((ItemLike)Items.BLAST_FURNACE)});
        registry.addWorkstations(CAMPFIRE, new EntryStack[]{EntryStacks.of((ItemLike)Items.CAMPFIRE), EntryStacks.of((ItemLike)Items.SOUL_CAMPFIRE)});
        registry.addWorkstations(FUEL, new EntryStack[]{EntryStacks.of((ItemLike)Items.FURNACE), EntryStacks.of((ItemLike)Items.SMOKER), EntryStacks.of((ItemLike)Items.BLAST_FURNACE)});
        registry.addWorkstations(BREWING, new EntryStack[]{EntryStacks.of((ItemLike)Items.BREWING_STAND)});
        registry.addWorkstations(ANVIL, new EntryStack[]{EntryStacks.of((ItemLike)Items.ANVIL)});
        registry.addWorkstations(STONE_CUTTING, new EntryStack[]{EntryStacks.of((ItemLike)Items.STONECUTTER)});
        registry.addWorkstations(COMPOSTING, new EntryStack[]{EntryStacks.of((ItemLike)Items.COMPOSTER)});
        registry.addWorkstations(SMITHING, new EntryStack[]{EntryStacks.of((ItemLike)Items.SMITHING_TABLE)});
        registry.addWorkstations(BEACON_BASE, new EntryStack[]{EntryStacks.of((ItemLike)Items.BEACON)});
        registry.addWorkstations(BEACON_PAYMENT, new EntryStack[]{EntryStacks.of((ItemLike)Items.BEACON)});
        registry.addWorkstations(WAXING, new EntryStack[]{EntryStacks.of((ItemLike)Items.HONEYCOMB)});
        registry.configure(INFO, config -> config.setQuickCraftingEnabledByDefault(false));
        registry.configure(TAG, config -> config.setQuickCraftingEnabledByDefault(false));
        registry.registerVisibilityPredicate(category -> {
            if (category instanceof DefaultTagCategory && Minecraft.getInstance().getSingleplayerServer() == null && !NetworkManager.canServerReceive((Identifier)TagNodes.REQUEST_TAGS_C2S_PACKET_ID)) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        HashSet axes = Sets.newHashSet();
        HashSet hoes = Sets.newHashSet();
        HashSet shovels = Sets.newHashSet();
        EntryRegistry.getInstance().getEntryStacks().filter(stack -> stack.getValueType() == ItemStack.class).map(stack -> ((ItemStack)stack.getValue()).getItem()).forEach(item -> {
            if (item instanceof AxeItem && axes.add(item)) {
                registry.addWorkstations(STRIPPING, new EntryStack[]{EntryStacks.of((ItemLike)item)});
                registry.addWorkstations(WAX_SCRAPING, new EntryStack[]{EntryStacks.of((ItemLike)item)});
                registry.addWorkstations(OXIDATION_SCRAPING, new EntryStack[]{EntryStacks.of((ItemLike)item)});
            }
            if (item instanceof HoeItem && hoes.add(item)) {
                registry.addWorkstations(TILLING, new EntryStack[]{EntryStacks.of((ItemLike)item)});
            }
            if (item instanceof ShovelItem && shovels.add(item)) {
                registry.addWorkstations(PATHING, new EntryStack[]{EntryStacks.of((ItemLike)item)});
            }
        });
        for (EntryStack stack2 : DefaultClientPlugin.getTag(Identifier.fromNamespaceAndPath((String)"c", (String)"axes"))) {
            if (!axes.add(((ItemStack)stack2.castValue()).getItem())) continue;
            registry.addWorkstations(STRIPPING, new EntryStack[]{stack2});
            registry.addWorkstations(WAX_SCRAPING, new EntryStack[]{stack2});
            registry.addWorkstations(OXIDATION_SCRAPING, new EntryStack[]{stack2});
        }
        for (EntryStack stack2 : DefaultClientPlugin.getTag(Identifier.fromNamespaceAndPath((String)"c", (String)"hoes"))) {
            if (!hoes.add(((ItemStack)stack2.castValue()).getItem())) continue;
            registry.addWorkstations(TILLING, new EntryStack[]{stack2});
        }
        for (EntryStack stack2 : DefaultClientPlugin.getTag(Identifier.fromNamespaceAndPath((String)"c", (String)"shovels"))) {
            if (!shovels.add(((ItemStack)stack2.castValue()).getItem())) continue;
            registry.addWorkstations(PATHING, new EntryStack[]{stack2});
        }
    }

    private static EntryIngredient getTag(Identifier tagId) {
        return EntryIngredients.ofItemTag((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (Identifier)tagId));
    }

    public void registerDisplays(DisplayRegistry registry) {
        CategoryRegistry.getInstance().add(new DisplayCategory[]{new DefaultInformationCategory(), new DefaultTagCategory()});
        registry.beginRecipeFiller(ShapedCraftingRecipeDisplay.class).filterType(ShapedCraftingRecipeDisplay.TYPE).fill(ClientsidedCraftingDisplay.Shaped::new);
        registry.beginRecipeFiller(ShapelessCraftingRecipeDisplay.class).filterType(ShapelessCraftingRecipeDisplay.TYPE).fill(ClientsidedCraftingDisplay.Shapeless::new);
        registry.beginRecipeFiller(FurnaceRecipeDisplay.class).filterType(FurnaceRecipeDisplay.TYPE).filter((display, r) -> EntryIngredients.ofSlotDisplay((SlotDisplay)display.craftingStation()).contains((Object)EntryStacks.of((ItemLike)Items.FURNACE))).fill(ClientsidedCookingDisplay.Smelting::new);
        registry.beginRecipeFiller(FurnaceRecipeDisplay.class).filterType(FurnaceRecipeDisplay.TYPE).filter((display, r) -> EntryIngredients.ofSlotDisplay((SlotDisplay)display.craftingStation()).contains((Object)EntryStacks.of((ItemLike)Items.SMOKER))).fill(ClientsidedCookingDisplay.Smoking::new);
        registry.beginRecipeFiller(FurnaceRecipeDisplay.class).filterType(FurnaceRecipeDisplay.TYPE).filter((display, r) -> EntryIngredients.ofSlotDisplay((SlotDisplay)display.craftingStation()).contains((Object)EntryStacks.of((ItemLike)Items.BLAST_FURNACE))).fill(ClientsidedCookingDisplay.Blasting::new);
        registry.beginFiller(AnvilRecipe.class).fill(DefaultAnvilDisplay::new);
        registry.beginFiller(BrewingRecipe.class).fill(DefaultBrewingDisplay::new);
        registry.beginFiller(TagKey.class).fill(tagKey -> {
            if (tagKey.isFor(Registries.ITEM)) {
                return DefaultTagDisplay.ofItems((TagKey<ItemLike>)tagKey);
            }
            if (tagKey.isFor(Registries.BLOCK)) {
                return DefaultTagDisplay.ofItems((TagKey<ItemLike>)tagKey);
            }
            if (tagKey.isFor(Registries.FLUID)) {
                return DefaultTagDisplay.ofFluids((TagKey<Fluid>)tagKey);
            }
            return null;
        });
        if (ComposterBlock.COMPOSTABLES.isEmpty()) {
            ComposterBlock.bootStrap();
        }
        UnmodifiableIterator iterator = Iterators.partition(ComposterBlock.COMPOSTABLES.object2FloatEntrySet().stream().sorted(Map.Entry.comparingByValue()).map(entry -> EntryIngredients.of((ItemLike)((ItemLike)entry.getKey()))).iterator(), (int)35);
        while (iterator.hasNext()) {
            List entries = (List)iterator.next();
            registry.add((Display)new DefaultCompostingDisplay(entries, Collections.singletonList(EntryIngredients.of((ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL)))));
        }
        DummyAxeItem.getStrippedBlocksMap().entrySet().stream().sorted(Comparator.comparing(b -> BuiltInRegistries.BLOCK.getKey((Object)((Block)b.getKey())))).forEach(set -> registry.add((Display)new DefaultStrippingDisplay(EntryStacks.of((ItemLike)((ItemLike)set.getKey())), EntryStacks.of((ItemLike)((ItemLike)set.getValue())))));
        DummyShovelItem.getPathBlocksMap().entrySet().stream().sorted(Comparator.comparing(b -> BuiltInRegistries.BLOCK.getKey((Object)((Block)b.getKey())))).forEach(set -> registry.add((Display)new DefaultPathingDisplay(EntryStacks.of((ItemLike)((ItemLike)set.getKey())), EntryStacks.of((ItemLike)((BlockState)set.getValue()).getBlock()))));
        registry.add((Display)new DefaultBeaconBaseDisplay(Collections.singletonList(EntryIngredients.ofItemTag((TagKey)BlockTags.BEACON_BASE_BLOCKS)), Collections.emptyList()));
        registry.add((Display)new DefaultBeaconPaymentDisplay(Collections.singletonList(EntryIngredients.ofItemTag((TagKey)ItemTags.BEACON_PAYMENT_ITEMS)), Collections.emptyList()));
        ((BiMap)HoneycombItem.WAXABLES.get()).entrySet().stream().sorted(Comparator.comparing(b -> BuiltInRegistries.BLOCK.getKey((Object)((Block)b.getKey())))).forEach(set -> registry.add((Display)new DefaultWaxingDisplay(EntryStacks.of((ItemLike)((ItemLike)set.getKey())), EntryStacks.of((ItemLike)((ItemLike)set.getValue())))));
        ((BiMap)HoneycombItem.WAX_OFF_BY_BLOCK.get()).entrySet().stream().sorted(Comparator.comparing(b -> BuiltInRegistries.BLOCK.getKey((Object)((Block)b.getKey())))).forEach(set -> registry.add((Display)new DefaultWaxScrapingDisplay(EntryStacks.of((ItemLike)((ItemLike)set.getKey())), EntryStacks.of((ItemLike)((ItemLike)set.getValue())))));
        ((BiMap)WeatheringCopper.NEXT_BY_BLOCK.get()).entrySet().stream().sorted(Comparator.comparing(b -> BuiltInRegistries.BLOCK.getKey((Object)((Block)b.getKey())))).forEach(set -> registry.add((Display)new DefaultOxidizingDisplay(EntryStacks.of((ItemLike)((ItemLike)set.getKey())), EntryStacks.of((ItemLike)((ItemLike)set.getValue())))));
        ((BiMap)WeatheringCopper.PREVIOUS_BY_BLOCK.get()).entrySet().stream().sorted(Comparator.comparing(b -> BuiltInRegistries.BLOCK.getKey((Object)((Block)b.getKey())))).forEach(set -> registry.add((Display)new DefaultOxidationScrapingDisplay(EntryStacks.of((ItemLike)((ItemLike)set.getKey())), EntryStacks.of((ItemLike)((ItemLike)set.getValue())))));
        if (Platform.isFabric()) {
            Holder to;
            Ingredient ingredient;
            Holder from;
            Set potions = Collections.newSetFromMap(new LinkedTreeMap(Comparator.comparing(Holder::getRegisteredName), false));
            PotionBrewing brewing = Minecraft.getInstance().level.potionBrewing();
            for (Ingredient container : brewing.containers) {
                for (PotionBrewing.Mix mix : brewing.potionMixes) {
                    from = mix.from();
                    ingredient = mix.ingredient();
                    to = mix.to();
                    EntryIngredient base = EntryIngredients.ofIngredient((Ingredient)container).map(stack -> {
                        EntryStack copied = stack.copy();
                        ((ItemStack)copied.castValue()).set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(from));
                        return copied;
                    });
                    EntryIngredient output = EntryIngredients.ofIngredient((Ingredient)container).map(stack -> {
                        EntryStack copied = stack.copy();
                        ((ItemStack)copied.castValue()).set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(to));
                        return copied;
                    });
                    this.registerBrewingRecipe(base, EntryIngredients.ofIngredient((Ingredient)ingredient), output);
                    potions.add(from);
                    potions.add(to);
                }
            }
            Iterator iterator2 = potions.iterator();
            while (iterator2.hasNext()) {
                Holder potion = (Holder)iterator2.next();
                for (PotionBrewing.Mix mix : brewing.containerMixes) {
                    from = mix.from();
                    ingredient = mix.ingredient();
                    to = mix.to();
                    ItemStack baseStack = new ItemStack(from);
                    baseStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potion));
                    EntryIngredient base = EntryIngredients.of((ItemStack)baseStack);
                    ItemStack output = new ItemStack(to);
                    output.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potion));
                    this.registerBrewingRecipe(base, EntryIngredients.ofIngredient((Ingredient)ingredient), EntryIngredients.of((ItemStack)output));
                }
            }
        } else {
            this.registerForgePotions(registry, this);
        }
        for (Item item : BuiltInRegistries.ITEM) {
            Repairable repairable;
            EntryIngredient repairMaterialBase;
            ItemStack stack2 = item.getDefaultInstance();
            if (!stack2.isDamageableItem() || !item.components().has(DataComponents.REPAIRABLE) || (repairMaterialBase = EntryIngredients.ofItemsHolderSet((HolderSet)(repairable = (Repairable)item.components().get(DataComponents.REPAIRABLE)).items())).isEmpty()) continue;
            int[] i = new int[]{1};
            while (i[0] <= 4) {
                ItemStack baseStack = item.getDefaultInstance();
                int toRepair = i[0] == 4 ? baseStack.getMaxDamage() : baseStack.getMaxDamage() / 4 * i[0];
                baseStack.setDamageValue(toRepair);
                EntryIngredient repairMaterial = repairMaterialBase.map(s -> {
                    EntryStack newStack = s.copy();
                    ((ItemStack)newStack.castValue()).setCount(i[0]);
                    return newStack;
                });
                Optional<Pair<ItemStack, Integer>> output = DefaultAnvilDisplay.calculateOutput(baseStack, (ItemStack)((EntryStack)repairMaterial.get(0)).castValue());
                if (!output.isEmpty()) {
                    registry.add((Display)new DefaultAnvilDisplay(List.of(EntryIngredients.of((ItemStack)baseStack), repairMaterial), Collections.singletonList(EntryIngredients.of((ItemStack)((ItemStack)output.get().getLeft()))), Optional.empty(), OptionalInt.of((Integer)output.get().getRight())));
                }
                i[0] = i[0] + 1;
            }
        }
        List<Pair> enchantmentBooks = BasicDisplay.registryAccess().lookup(Registries.ENCHANTMENT).stream().flatMap(HolderLookup::listElements).flatMap(holder -> {
            if (!holder.isBound()) {
                return Stream.empty();
            }
            Enchantment enchantment = (Enchantment)holder.value();
            if (enchantment.getMaxLevel() - enchantment.getMinLevel() >= 10) {
                return IntStream.of(enchantment.getMinLevel(), enchantment.getMaxLevel()).mapToObj(lvl -> new EnchantmentInstance((Holder)holder, lvl));
            }
            return IntStream.rangeClosed(enchantment.getMinLevel(), enchantment.getMaxLevel()).mapToObj(lvl -> new EnchantmentInstance((Holder)holder, lvl));
        }).map(instance -> Pair.of((Object)instance, (Object)EnchantmentHelper.createBook((EnchantmentInstance)instance))).toList();
        EntryRegistry.getInstance().getEntryStacks().forEach(stack -> {
            if (stack.getType() != VanillaEntryTypes.ITEM) {
                return;
            }
            ItemStack itemStack = (ItemStack)stack.castValue();
            if (!itemStack.isEnchantable()) {
                return;
            }
            for (Pair pair : enchantmentBooks) {
                Optional<Pair<ItemStack, Integer>> output;
                if (!((Enchantment)((EnchantmentInstance)pair.getKey()).enchantment().value()).canEnchant(itemStack) || (output = DefaultAnvilDisplay.calculateOutput(itemStack, (ItemStack)pair.getValue())).isEmpty()) continue;
                registry.add((Display)new DefaultAnvilDisplay(List.of(EntryIngredients.of((ItemStack)itemStack), EntryIngredients.of((ItemStack)((ItemStack)pair.getValue()))), Collections.singletonList(EntryIngredients.of((ItemStack)((ItemStack)output.get().getLeft()))), Optional.empty(), OptionalInt.of((Integer)output.get().getRight())));
            }
        });
        for (Registry reg : BuiltInRegistries.REGISTRY) {
            reg.getTags().forEach(tagPair -> tagPair.unwrap().ifLeft(arg_0 -> ((DisplayRegistry)registry).add(arg_0)));
        }
    }

    protected void registerForgePotions(DisplayRegistry registry, BuiltinClientPlugin clientPlugin) {
    }

    public void registerExclusionZones(ExclusionZones zones) {
        zones.register(InventoryScreen.class, new DefaultPotionEffectExclusionZones());
        zones.register(CreativeModeInventoryScreen.class, new DefaultPotionEffectExclusionZones());
        zones.register(RecipeUpdateListener.class, (ExclusionZonesProvider)new DefaultRecipeBookExclusionZones());
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerContainerClickArea(new Rectangle(88, 32, 28, 23), CraftingScreen.class, new CategoryIdentifier[]{CRAFTING});
        registry.registerContainerClickArea(new Rectangle(137, 29, 10, 13), InventoryScreen.class, new CategoryIdentifier[]{CRAFTING});
        registry.registerContainerClickArea(new Rectangle(97, 16, 14, 30), BrewingStandScreen.class, new CategoryIdentifier[]{BREWING});
        registry.registerContainerClickArea(new Rectangle(78, 32, 28, 23), FurnaceScreen.class, new CategoryIdentifier[]{SMELTING});
        registry.registerContainerClickArea(new Rectangle(78, 32, 28, 23), SmokerScreen.class, new CategoryIdentifier[]{SMOKING});
        registry.registerContainerClickArea(new Rectangle(78, 32, 28, 23), BlastFurnaceScreen.class, new CategoryIdentifier[]{BLASTING});
    }

    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register((TransferHandler)SimpleTransferHandler.create(CraftingMenu.class, BuiltinPlugin.CRAFTING, (SimpleTransferHandler.IntRange)new SimpleTransferHandler.IntRange(1, 10)));
        registry.register((TransferHandler)new InventoryCraftingTransferHandler(SimpleTransferHandler.create(InventoryMenu.class, BuiltinPlugin.CRAFTING, (SimpleTransferHandler.IntRange)new SimpleTransferHandler.IntRange(1, 5))));
        registry.register((TransferHandler)SimpleTransferHandler.create(FurnaceMenu.class, BuiltinPlugin.SMELTING, (SimpleTransferHandler.IntRange)new SimpleTransferHandler.IntRange(0, 1)));
        registry.register((TransferHandler)SimpleTransferHandler.create(SmokerMenu.class, BuiltinPlugin.SMOKING, (SimpleTransferHandler.IntRange)new SimpleTransferHandler.IntRange(0, 1)));
        registry.register((TransferHandler)SimpleTransferHandler.create(BlastFurnaceMenu.class, BuiltinPlugin.BLASTING, (SimpleTransferHandler.IntRange)new SimpleTransferHandler.IntRange(0, 1)));
        registry.register((TransferHandler)new DefaultRecipeBookHandler());
    }

    public void registerFavorites(FavoriteEntryType.Registry registry) {
        registry.register(GameModeFavoriteEntry.ID, (FavoriteEntryType)GameModeFavoriteEntry.Type.INSTANCE);
        registry.getOrCrateSection((Component)Component.translatable((String)"favorite.section.gamemode")).add((FavoriteEntry[])Stream.concat(Arrays.stream(GameType.values()).filter(type -> type.getId() >= 0), Stream.of((GameType)null)).map(GameModeFavoriteEntry::new).toArray(FavoriteEntry[]::new));
        registry.register(WeatherFavoriteEntry.ID, (FavoriteEntryType)WeatherFavoriteEntry.Type.INSTANCE);
        registry.getOrCrateSection((Component)Component.translatable((String)"favorite.section.weather")).add((FavoriteEntry[])Stream.concat(Arrays.stream(WeatherFavoriteEntry.Weather.values()), Stream.of((WeatherFavoriteEntry.Weather)null)).map(WeatherFavoriteEntry::new).toArray(FavoriteEntry[]::new));
        registry.register(TimeFavoriteEntry.ID, (FavoriteEntryType)TimeFavoriteEntry.Type.INSTANCE);
        registry.getOrCrateSection((Component)Component.translatable((String)"favorite.section.time")).add((FavoriteEntry[])Stream.concat(Arrays.stream(TimeFavoriteEntry.Time.values()), Stream.of((TimeFavoriteEntry.Time)null)).map(TimeFavoriteEntry::new).toArray(FavoriteEntry[]::new));
    }

    public double getPriority() {
        return -100.0;
    }

    public static class DummyAxeItem
    extends AxeItem {
        public DummyAxeItem(ToolMaterial material, float damage, float speed, Item.Properties properties) {
            super(material, damage, speed, properties);
        }

        public static Map<Block, Block> getStrippedBlocksMap() {
            return STRIPPABLES;
        }
    }

    public static class DummyShovelItem
    extends ShovelItem {
        public DummyShovelItem(ToolMaterial material, float damage, float speed, Item.Properties properties) {
            super(material, damage, speed, properties);
        }

        public static Map<Block, BlockState> getPathBlocksMap() {
            return FLATTENABLES;
        }
    }
}

