/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.tag;

import com.mojang.serialization.DataResult;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.impl.NetworkAggregator;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.transformers.SplitPacketTransformer;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.plugin.common.displays.tag.TagNode;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class TagNodes {
    public static final ResourceLocation REQUEST_TAGS_PACKET_C2S = ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"request_tags_c2s");
    public static final ResourceLocation REQUEST_TAGS_PACKET_S2C = ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"request_tags_s2c");
    public static final Map<String, ResourceKey<? extends Registry<?>>> TAG_DIR_MAP = new HashMap();
    public static final ThreadLocal<String> CURRENT_TAG_DIR = new ThreadLocal();
    public static final Map<String, Map<CollectionWrapper<?>, RawTagData>> RAW_TAG_DATA_MAP = new ConcurrentHashMap();
    public static final Map<ResourceKey<? extends Registry<?>>, Map<ResourceLocation, TagData>> TAG_DATA_MAP = new HashMap();
    public static Map<ResourceKey<? extends Registry<?>>, Consumer<Consumer<DataResult<Map<ResourceLocation, TagData>>>>> requestedTags = new HashMap();

    private static void writeResourceLocation(FriendlyByteBuf buf, ResourceLocation location) {
        if (location.getNamespace().equals("minecraft")) {
            buf.writeUtf(location.getPath());
        } else {
            buf.writeUtf(location.toString());
        }
    }

    public static void init() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> Client::init);
        if (Platform.getEnvironment() != Env.CLIENT) {
            NetworkAggregator.registerS2CType((ResourceLocation)REQUEST_TAGS_PACKET_S2C, Collections.singletonList(new SplitPacketTransformer()));
        }
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)REQUEST_TAGS_PACKET_C2S, Collections.singletonList(new SplitPacketTransformer()), (buf, context) -> {
            UUID uuid = buf.readUUID();
            ResourceKey resourceKey = ResourceKey.createRegistryKey((ResourceLocation)buf.readResourceLocation());
            RegistryFriendlyByteBuf newBuf = new RegistryFriendlyByteBuf(Unpooled.buffer(), context.registryAccess());
            newBuf.writeUUID(uuid);
            Map dataMap = TAG_DATA_MAP.getOrDefault(resourceKey, Collections.emptyMap());
            newBuf.writeInt(dataMap.size());
            for (Map.Entry entry : dataMap.entrySet()) {
                TagNodes.writeResourceLocation((FriendlyByteBuf)newBuf, (ResourceLocation)entry.getKey());
                ((TagData)entry.getValue()).toNetwork((FriendlyByteBuf)newBuf);
            }
            NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)context.getPlayer()), (ResourceLocation)REQUEST_TAGS_PACKET_S2C, (RegistryFriendlyByteBuf)newBuf);
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void requestTagData(ResourceKey<? extends Registry<?>> resourceKey, Consumer<DataResult<Map<ResourceLocation, TagData>>> callback) {
        if (Minecraft.getInstance().getSingleplayerServer() != null) {
            callback.accept((DataResult<Map<ResourceLocation, TagData>>)DataResult.success(TAG_DATA_MAP.get(resourceKey)));
        } else if (!NetworkManager.canServerReceive((ResourceLocation)REQUEST_TAGS_PACKET_C2S)) {
            callback.accept((DataResult<Map<ResourceLocation, TagData>>)DataResult.error(() -> "Cannot request tags from server"));
        } else if (requestedTags.containsKey(resourceKey)) {
            requestedTags.get(resourceKey).accept(callback);
            callback.accept((DataResult<Map<ResourceLocation, TagData>>)DataResult.success(TAG_DATA_MAP.getOrDefault(resourceKey, Collections.emptyMap())));
        } else {
            RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), BasicDisplay.registryAccess());
            UUID uuid = UUID.randomUUID();
            buf.writeUUID(uuid);
            buf.writeResourceLocation(resourceKey.location());
            Client.nextUUID = uuid;
            Client.nextResourceKey = resourceKey;
            CopyOnWriteArrayList<Consumer<DataResult<Map<ResourceLocation, TagData>>>> callbacks = new CopyOnWriteArrayList<Consumer<DataResult<Map<ResourceLocation, TagData>>>>();
            callbacks.add(callback);
            Client.nextCallback = mapDataResult -> {
                requestedTags.put(resourceKey, c -> c.accept(mapDataResult));
                for (Consumer consumer : callbacks) {
                    consumer.accept(mapDataResult);
                }
            };
            requestedTags.put(resourceKey, callbacks::add);
            NetworkManager.sendToServer((ResourceLocation)REQUEST_TAGS_PACKET_C2S, (RegistryFriendlyByteBuf)buf);
        }
    }

    public static <T> void create(TagKey<T> tagKey, Consumer<DataResult<TagNode<T>>> callback) {
        Registry registry = (Registry)BuiltInRegistries.REGISTRY.getValueOrThrow(tagKey.registry());
        TagNodes.requestTagData(tagKey.registry(), result -> callback.accept(result.flatMap(dataMap -> dataMap != null ? TagNodes.resolveTag(tagKey, registry, dataMap).orElse(DataResult.error(() -> "No tag data")) : DataResult.error(() -> "No tag data"))));
    }

    private static <T> Optional<DataResult<TagNode<T>>> resolveTag(TagKey<T> tagKey, Registry<T> registry, Map<ResourceLocation, TagData> tagDataMap) {
        TagData tagData = tagDataMap.get(tagKey.location());
        if (tagData == null) {
            return Optional.empty();
        }
        TagNode<T> self = TagNode.ofReference(tagKey);
        ArrayList<Holder> holders = new ArrayList<Holder>();
        IntListIterator intListIterator = tagData.otherElements().iterator();
        while (intListIterator.hasNext()) {
            int element = (Integer)intListIterator.next();
            Optional holder = registry.get(element);
            if (!holder.isPresent()) continue;
            holders.add((Holder)holder.get());
        }
        if (!holders.isEmpty()) {
            self.addValuesChild((HolderSet<T>)HolderSet.direct(holders));
        }
        for (ResourceLocation childTagId : tagData.otherTags()) {
            Optional<DataResult<TagNode<T>>> resultOptional;
            TagKey childTagKey = TagKey.create((ResourceKey)tagKey.registry(), (ResourceLocation)childTagId);
            if (!registry.get(childTagKey).isPresent() || !(resultOptional = TagNodes.resolveTag(childTagKey, registry, tagDataMap)).isPresent()) continue;
            DataResult result = resultOptional.get();
            if (result.error().isPresent()) {
                return Optional.of(DataResult.error(() -> ((DataResult.Error)result.error().get()).message()));
            }
            self.addChild((TagNode)result.result().get());
        }
        return Optional.of(DataResult.success(self));
    }

    private static class Client {
        public static UUID nextUUID;
        public static ResourceKey<? extends Registry<?>> nextResourceKey;
        public static Consumer<DataResult<Map<ResourceLocation, TagData>>> nextCallback;

        private Client() {
        }

        private static void init() {
            ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(world -> requestedTags.clear());
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)REQUEST_TAGS_PACKET_S2C, (buf, context) -> {
                UUID uuid = buf.readUUID();
                if (nextUUID.equals(uuid)) {
                    HashMap<ResourceLocation, TagData> map = new HashMap<ResourceLocation, TagData>();
                    int count = buf.readInt();
                    for (int i = 0; i < count; ++i) {
                        map.put(buf.readResourceLocation(), TagData.fromNetwork((FriendlyByteBuf)buf));
                    }
                    TAG_DATA_MAP.put(nextResourceKey, map);
                    nextCallback.accept((DataResult<Map<ResourceLocation, TagData>>)DataResult.success(map));
                    nextUUID = null;
                    nextResourceKey = null;
                    nextCallback = null;
                }
            });
        }
    }

    public record TagData(IntList otherElements, List<ResourceLocation> otherTags) {
        private static TagData fromNetwork(FriendlyByteBuf buf) {
            int count = buf.readVarInt();
            IntArrayList otherElements = new IntArrayList(count + 1);
            for (int i = 0; i < count; ++i) {
                otherElements.add(buf.readVarInt());
            }
            count = buf.readVarInt();
            ArrayList<ResourceLocation> otherTags = new ArrayList<ResourceLocation>(count + 1);
            for (int i = 0; i < count; ++i) {
                otherTags.add(buf.readResourceLocation());
            }
            return new TagData((IntList)otherElements, otherTags);
        }

        private void toNetwork(FriendlyByteBuf buf) {
            buf.writeVarInt(this.otherElements.size());
            IntListIterator intListIterator = this.otherElements.iterator();
            while (intListIterator.hasNext()) {
                int integer = (Integer)intListIterator.next();
                buf.writeVarInt(integer);
            }
            buf.writeVarInt(this.otherTags.size());
            for (ResourceLocation tag : this.otherTags) {
                TagNodes.writeResourceLocation(buf, tag);
            }
        }
    }

    public record RawTagData(List<ResourceLocation> otherElements, List<ResourceLocation> otherTags) {
    }

    public static class CollectionWrapper<T> {
        private final Collection<T> collection;

        public CollectionWrapper(Collection<T> collection) {
            this.collection = collection;
        }

        public boolean equals(Object obj) {
            return obj instanceof CollectionWrapper && ((CollectionWrapper)obj).collection == this.collection;
        }

        public int hashCode() {
            return System.identityHashCode(this.collection);
        }
    }
}

