/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories.tag;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.util.MatrixUtils;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.plugin.client.categories.tag.TagNodeWidget;
import me.shedaniel.rei.plugin.common.displays.tag.TagNode;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Holder;
import org.joml.Matrix4f;

public class TagTreeWidget<S, T>
extends WidgetWithBounds {
    private final Rectangle bounds;
    private final TagNode<S> node;
    private final Rectangle overflowBounds;
    private final TagNodeWidget<S, T> rootWidget;
    private final List<TagTreeWidget<S, T>> childWidgets;
    private final List<WidgetWithBounds> children;

    public TagTreeWidget(TagNode<S> node, Function<Holder<S>, EntryStack<T>> mapper, Rectangle overflowBounds) {
        this.node = node;
        this.overflowBounds = overflowBounds;
        this.rootWidget = TagNodeWidget.create(node, mapper, overflowBounds);
        this.childWidgets = new ArrayList<TagTreeWidget<S, T>>();
        for (TagNode<S> childNode : node.children()) {
            TagTreeWidget<S, T> childWidget = new TagTreeWidget<S, T>(childNode, mapper, overflowBounds);
            childWidget.getBounds().y = this.rootWidget.getBounds().getMaxY() + 16;
            this.childWidgets.add(childWidget);
        }
        int childrenTotalWidth = this.childWidgets.stream().map(WidgetWithBounds::getBounds).mapToInt(value -> value.width + 6).sum() - 6;
        int x = 0;
        for (TagTreeWidget<S, T> childWidget : this.childWidgets) {
            childWidget.getBounds().x = this.rootWidget.getBounds().getCenterX() - childrenTotalWidth / 2 + x;
            x += childWidget.getBounds().width + 6;
        }
        this.children = Stream.concat(Stream.of(this.rootWidget), this.childWidgets.stream()).toList();
        this.bounds = new Rectangle(this.children.stream().map(WidgetWithBounds::getBounds).reduce(Rectangle::union).orElse(new Rectangle()).getSize());
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.rootWidget.getBounds().setLocation(this.getBounds().getCenterX() - this.rootWidget.getBounds().getWidth() / 2, this.getBounds().y);
        this.rootWidget.render(graphics, mouseX, mouseY, delta);
        if (this.childWidgets.isEmpty()) {
            return;
        }
        graphics.vLine(this.rootWidget.getBounds().getCenterX(), this.rootWidget.getBounds().getMaxY(), this.rootWidget.getBounds().getMaxY() + 6, -1);
        int childrenTotalWidth = this.childWidgets.stream().map(WidgetWithBounds::getBounds).mapToInt(value -> value.width + 6).sum() - 6;
        graphics.hLine(this.rootWidget.getBounds().getCenterX() - childrenTotalWidth / 2 + this.childWidgets.get((int)0).getBounds().width / 2, this.rootWidget.getBounds().getCenterX() + childrenTotalWidth / 2 - this.childWidgets.get((int)(this.childWidgets.size() - 1)).getBounds().width / 2, this.rootWidget.getBounds().getMaxY() + 6, -1);
        int x = 0;
        for (TagTreeWidget<S, T> childWidget : this.childWidgets) {
            graphics.vLine(this.getBounds().getCenterX() - childrenTotalWidth / 2 + x + childWidget.getBounds().width / 2, this.rootWidget.getBounds().getMaxY() + 6, this.rootWidget.getBounds().getMaxY() + 16, -1);
            childWidget.getBounds().setLocation(this.getBounds().getCenterX() - childrenTotalWidth / 2 + x, this.rootWidget.getBounds().getMaxY() + 16);
            if (this.overflowBounds.intersects(MatrixUtils.transform((Matrix4f)graphics.pose().last().pose(), (Rectangle)childWidget.getBounds()))) {
                childWidget.render(graphics, mouseX, mouseY, delta);
            }
            x += childWidget.getBounds().width + 6;
        }
    }

    public List<? extends GuiEventListener> children() {
        return this.children;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (GuiEventListener element : this.children()) {
            if (!element.mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (GuiEventListener element : this.children()) {
            if (!element.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }
}

