/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories.crafting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.DisplayMerger;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.crafting.CraftingDisplay;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class DefaultCraftingCategory
implements DisplayCategory<CraftingDisplay> {
    public CategoryIdentifier<? extends CraftingDisplay> getCategoryIdentifier() {
        return BuiltinPlugin.CRAFTING;
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)Blocks.CRAFTING_TABLE);
    }

    public Component getTitle() {
        return Component.translatable((String)"category.rei.crafting");
    }

    public List<Widget> setupDisplay(CraftingDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 58, bounds.getCenterY() - 27);
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createArrow((Point)new Point(startPoint.x + 60, startPoint.y + 18)));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 95, startPoint.y + 19)));
        List<InputIngredient<EntryStack<?>>> input = display.getInputIngredients(3, 3);
        ArrayList slots = Lists.newArrayList();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                slots.add(Widgets.createSlot((Point)new Point(startPoint.x + 1 + x * 18, startPoint.y + 1 + y * 18)).markInput());
            }
        }
        for (InputIngredient<EntryStack<?>> ingredient : input) {
            ((Slot)slots.get(ingredient.getIndex())).entries((Collection)ingredient.get());
        }
        widgets.addAll(slots);
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 95, startPoint.y + 19)).entries((Collection)display.getOutputEntries().get(0)).disableBackground().markOutput());
        if (display.isShapeless()) {
            widgets.add(Widgets.createShapelessIcon((Rectangle)bounds));
        }
        return widgets;
    }

    @Nullable
    public DisplayMerger<CraftingDisplay> getDisplayMerger() {
        return new DisplayMerger<CraftingDisplay>(this){

            public boolean canMerge(CraftingDisplay first, CraftingDisplay second) {
                if (!first.getCategoryIdentifier().equals((Object)second.getCategoryIdentifier())) {
                    return false;
                }
                if (!this.equals(first.getOrganisedInputEntries(3, 3), second.getOrganisedInputEntries(3, 3))) {
                    return false;
                }
                if (!this.equals(first.getOutputEntries(), second.getOutputEntries())) {
                    return false;
                }
                if (first.isShapeless() != second.isShapeless()) {
                    return false;
                }
                if (first.getWidth() != second.getWidth()) {
                    return false;
                }
                return first.getHeight() == second.getHeight();
            }

            public int hashOf(CraftingDisplay display) {
                return display.getCategoryIdentifier().hashCode() * 31 * 31 * 31 + display.getOrganisedInputEntries(3, 3).hashCode() * 31 * 31 + display.getOutputEntries().hashCode();
            }

            private boolean equals(List<EntryIngredient> l1, List<EntryIngredient> l2) {
                if (l1.size() != l2.size()) {
                    return false;
                }
                Iterator<EntryIngredient> it1 = l1.iterator();
                Iterator<EntryIngredient> it2 = l2.iterator();
                while (it1.hasNext() && it2.hasNext()) {
                    if (it1.next().equals((Object)it2.next())) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

