/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.common.displays;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;

import java.util.Arrays;
import java.util.List;

public class DefaultCompostingDisplay extends BasicDisplay {
    public static final DisplaySerializer<DefaultCompostingDisplay> SERIALIZER = DisplaySerializer.of(
            RecordCodecBuilder.mapCodec(instance -> instance.group(
                    EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(DefaultCompostingDisplay::getInputEntries),
                    EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(DefaultCompostingDisplay::getOutputEntries),
                    Codec.INT.fieldOf("page").forGetter(DefaultCompostingDisplay::getPage)
            ).apply(instance, DefaultCompostingDisplay::new)),
            class_9139.method_56436(
                    EntryIngredient.streamCodec().method_56433(class_9135.method_56363()),
                    DefaultCompostingDisplay::getInputEntries,
                    EntryIngredient.streamCodec().method_56433(class_9135.method_56363()),
                    DefaultCompostingDisplay::getOutputEntries,
                    class_9135.field_49675,
                    DefaultCompostingDisplay::getPage,
                    DefaultCompostingDisplay::new
            ));
    
    private static int pages;
    
    private final int page;
    
    @Deprecated(forRemoval = true)
    public static DefaultCompostingDisplay of(List<Object2FloatMap.Entry<class_1935>> inputs, List<EntryIngredient> output, int page) {
        EntryIngredient[] inputIngredients = new EntryIngredient[inputs.size()];
        int i = 0;
        for (Object2FloatMap.Entry<class_1935> entry : inputs) {
            inputIngredients[i] = EntryIngredients.of(entry.getKey());
            i++;
        }
        return new DefaultCompostingDisplay(Arrays.asList(inputIngredients), output, page);
    }
    
    @ApiStatus.Internal
    public DefaultCompostingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, class_2487 tag) {
        this(inputs, outputs, tag.method_10550("page").orElseThrow());
    }
    
    public DefaultCompostingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs) {
        super(inputs, outputs);
        this.page = pages++;
    }
    
    @ApiStatus.Internal
    public DefaultCompostingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, int page) {
        super(inputs, outputs);
        this.page = page;
        if (pages <= page) pages = page + 1;
    }
    
    public int getPage() {
        return page;
    }
    
    public static int getPages() {
        return pages;
    }
    
    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.COMPOSTING;
    }
    
    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}
