/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.client.categories.crafting.filler;

import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomShapelessDisplay;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1850;
import net.minecraft.class_8786;
import net.minecraft.class_9262;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import java.util.*;

public class BookCloningRecipeFiller implements CraftingRecipeFiller<class_1850> {
    private static final String[] TITLES = new String[]{
            "Adventurer's Dreams", "Adventurer's Diary", "The Lost Journal",
            "The Lost Diary", "The Lost Book", "The Lost Tome", "The Lost Codex",
            "The Last Journal", "The Last Diary", "The Last Book", "The Last Tome",
            "Secrets of the World", "Secrets of the Universe", "Secrets of the Cosmos",
            "Myths of the World", "Myths of the Universe", "Myths of the Cosmos",
            "Old Tales of the World", "Old Tales of the Universe", "Old Tales of the Cosmos",
            "The World of the Legends", "The Universe of the Heroes", "The Cosmos of the Gods",
            "Diary of a Villager", "Diary of a Farmer", "Diary of a Fisherman",
            "Dungeon Journal", "Dungeon Diary", "Dungeon Book", "Dungeon Tome",
            "Dunk Memes", "Top 10 Memes of 2019", "Top 10 Memes of 2020",
            "Plastic Memories", "Kizumonogatari"
    };
    private static final String[] AUTHORS = new String[]{
            "shedaniel", "Steve", "Alex", "Notch", "Herobrine", "God",
            "Santa Claus", "The Easter Bunny", "The Tooth Fairy"
    };
    
    @Override
    public Collection<Display> apply(class_8786<class_1850> recipe) {
        List<Display> displays = new ArrayList<>();
        
        for (int i = 1; i <= 8; i++) {
            EntryIngredient.Builder[] inputs = new EntryIngredient.Builder[9];
            for (int j = 0; j < 9; j++) {
                inputs[j] = EntryIngredient.builder();
            }
            EntryIngredient.Builder output = EntryIngredient.builder();
            for (int j = 0; j < 10; j++) {
                class_1799 writtenBook = generateBook();
                class_1799 bookAndQuill = new class_1799(class_1802.field_8674);
                inputs[0].add(EntryStacks.of(writtenBook));
                for (int k = 0; k < i; k++) {
                    inputs[k + 1].add(EntryStacks.of(bookAndQuill));
                }
                class_1799 cloned = writtenBook.method_7972();
                cloned.method_57368(class_9334.field_49606, class_9302.field_49829, class_9302::method_57519);
                cloned.method_7939(i);
                output.add(EntryStacks.of(cloned));
            }
            displays.add(new DefaultCustomShapelessDisplay(
                    CollectionUtils.map(inputs, EntryIngredient.Builder::build),
                    List.of(output.build()),
                    Optional.of(recipe.comp_1932().method_29177())));
        }
        
        return displays;
    }
    
    private class_1799 generateBook() {
        class_1799 stack = new class_1799(class_1802.field_8360);
        stack.method_57379(class_9334.field_49606, new class_9302(new class_9262<>(TITLES[new Random().nextInt(TITLES.length)], Optional.empty()),
                AUTHORS[new Random().nextInt(AUTHORS.length)], 0, List.of(), true));
        return stack;
    }
    
    @Override
    public Class<class_1850> getRecipeClass() {
        return class_1850.class;
    }
}
