/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.api.common.transfer.info.stack;

import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

/**
 * Simple implementation of {@link SlotAccessor} that wraps around {@link class_1735}.
 */
public class VanillaSlotAccessor implements SlotAccessor {
    protected class_1735 slot;
    
    public VanillaSlotAccessor(class_1735 slot) {
        this.slot = slot;
    }
    
    @Override
    public class_1799 getItemStack() {
        return slot.method_7677();
    }
    
    @Override
    public void setItemStack(class_1799 stack) {
        this.slot.method_7673(stack);
    }
    
    @Override
    public class_1799 takeStack(int amount) {
        return slot.method_7671(amount);
    }
    
    public class_1735 getSlot() {
        return slot;
    }
    
    @Override
    public boolean allowModification(class_1657 player) {
        return slot.method_32754(player);
    }
    
    @Override
    public boolean canPlace(class_1799 stack) {
        return slot.method_7680(stack);
    }
}
