/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.util;

import com.google.common.collect.ImmutableList;
import dev.architectury.fluid.FluidStack;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.Internals;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.tags.TagKey;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public final class EntryIngredients {
    private EntryIngredients() {
    }

    public static EntryIngredient of(ItemLike stack) {
        return EntryIngredient.of(EntryStacks.of(stack));
    }

    public static EntryIngredient of(ItemLike stack, int amount) {
        return EntryIngredient.of(EntryStacks.of(stack, amount));
    }

    public static EntryIngredient of(ItemStack stack) {
        return EntryIngredient.of(EntryStacks.of(stack));
    }

    public static EntryIngredient of(Fluid fluid) {
        return EntryIngredient.of(EntryStacks.of(fluid));
    }

    public static EntryIngredient of(Fluid fluid, long amount) {
        return EntryIngredient.of(EntryStacks.of(fluid, amount));
    }

    public static EntryIngredient of(FluidStack stack) {
        return EntryIngredient.of(EntryStacks.of(stack));
    }

    public static EntryIngredient ofFluidHolder(Holder<Fluid> fluid) {
        return EntryIngredient.of(EntryStacks.ofFluidHolder(fluid));
    }

    public static EntryIngredient ofFluidHolder(Holder<Fluid> fluid, long amount) {
        return EntryIngredient.of(EntryStacks.ofFluidHolder(fluid, amount));
    }

    public static EntryIngredient ofItemHolder(Holder<? extends ItemLike> item) {
        return EntryIngredient.of(EntryStacks.ofItemHolder(item));
    }

    public static EntryIngredient ofItemHolder(Holder<? extends ItemLike> item, int amount) {
        return EntryIngredient.of(EntryStacks.ofItemHolder(item, amount));
    }

    public static <T> EntryIngredient of(EntryType<T> type, Collection<T> values) {
        return EntryIngredients.of(type.getDefinition(), values);
    }

    public static <T> EntryIngredient of(EntryDefinition<T> definition, Collection<T> values) {
        if (values.size() == 0) {
            return EntryIngredient.empty();
        }
        if (values.size() == 1) {
            return EntryIngredient.of(EntryStack.of(definition, values.iterator().next()));
        }
        EntryIngredient.Builder result = EntryIngredient.builder(values.size());
        for (T value : values) {
            result.add((EntryStack<?>)EntryStack.of(definition, value));
        }
        return result.build();
    }

    public static <T> EntryIngredient from(Iterable<T> stacks, Function<T, ? extends EntryStack<?>> function) {
        if (stacks instanceof Collection) {
            Collection collection = (Collection)stacks;
            return EntryIngredients.from(collection, collection.size(), function);
        }
        if (!stacks.iterator().hasNext()) {
            return EntryIngredient.empty();
        }
        EntryIngredient.Builder result = EntryIngredient.builder();
        for (T t : stacks) {
            EntryStack<?> stack = function.apply(t);
            if (stack.isEmpty()) continue;
            result.add(stack);
        }
        return result.build();
    }

    public static <T> EntryIngredient from(Iterable<T> stacks, int size, Function<T, ? extends EntryStack<?>> function) {
        if (size == 0) {
            return EntryIngredient.empty();
        }
        if (size == 1) {
            return EntryIngredient.of(function.apply(stacks.iterator().next()));
        }
        EntryIngredient.Builder result = EntryIngredient.builder(size);
        for (T t : stacks) {
            EntryStack<?> stack = function.apply(t);
            if (stack.isEmpty()) continue;
            result.add(stack);
        }
        return result.build();
    }

    public static EntryIngredient ofItems(Collection<ItemLike> stacks) {
        return EntryIngredients.ofItems(stacks, 1);
    }

    public static EntryIngredient ofItems(Collection<ItemLike> stacks, int amount) {
        return EntryIngredients.from(stacks, stack -> EntryStacks.of(stack, amount));
    }

    public static EntryIngredient ofItemStacks(Collection<ItemStack> stacks) {
        return EntryIngredients.of(VanillaEntryTypes.ITEM, stacks);
    }

    public static EntryIngredient ofIngredient(Ingredient ingredient) {
        return Internals.toEntryIngredient(ingredient);
    }

    public static List<EntryIngredient> ofIngredients(List<Ingredient> ingredients) {
        if (ingredients.size() == 0) {
            return Collections.emptyList();
        }
        if (ingredients.size() == 1) {
            Ingredient ingredient = ingredients.get(0);
            EntryIngredient entryIngredient = EntryIngredients.ofIngredient(ingredient);
            if (entryIngredient.isEmpty()) {
                return List.of();
            }
            return List.of(entryIngredient);
        }
        boolean emptyFlag = true;
        ArrayList<EntryIngredient> result = new ArrayList<EntryIngredient>(ingredients.size());
        for (int i = ingredients.size() - 1; i >= 0; --i) {
            Ingredient ingredient = ingredients.get(i);
            EntryIngredient entryIngredient = EntryIngredients.ofIngredient(ingredient);
            if (emptyFlag && entryIngredient.isEmpty()) continue;
            result.add(0, entryIngredient);
            emptyFlag = false;
        }
        return ImmutableList.copyOf(result);
    }

    public static <S, T> EntryIngredient ofTag(HolderGetter.Provider provider, TagKey<S> tagKey, Function<Holder<S>, EntryStack<T>> mapper) {
        HolderGetter getter = provider.lookupOrThrow(tagKey.registry());
        HolderSet.Named holders = getter.get(tagKey).orElse(null);
        if (holders == null) {
            return EntryIngredient.empty();
        }
        return EntryIngredients.from(holders, holders.size(), mapper);
    }

    public static <S, T> List<EntryIngredient> ofTags(HolderGetter.Provider provider, Iterable<TagKey<S>> tagKeys, Function<Holder<S>, EntryStack<T>> mapper) {
        Collection collection;
        if (tagKeys instanceof Collection && (collection = (Collection)tagKeys).isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder ingredients = ImmutableList.builder();
        for (TagKey<S> tagKey : tagKeys) {
            ingredients.add((Object)EntryIngredients.ofTag(provider, tagKey, mapper));
        }
        return ingredients.build();
    }

    public static <T extends ItemLike> EntryIngredient ofItemTag(TagKey<T> tagKey) {
        return EntryIngredients.ofTag((HolderGetter.Provider)BasicDisplay.registryAccess(), tagKey, EntryStacks::ofItemHolder);
    }

    public static EntryIngredient ofFluidTag(TagKey<Fluid> tagKey) {
        return EntryIngredients.ofTag((HolderGetter.Provider)BasicDisplay.registryAccess(), tagKey, EntryStacks::ofFluidHolder);
    }

    public static <T extends ItemLike> List<EntryIngredient> ofItemTags(Iterable<TagKey<T>> tagKey) {
        return EntryIngredients.ofTags((HolderGetter.Provider)BasicDisplay.registryAccess(), tagKey, EntryStacks::ofItemHolder);
    }

    public static List<EntryIngredient> ofFluidTags(Iterable<TagKey<Fluid>> tagKey) {
        return EntryIngredients.ofTags((HolderGetter.Provider)BasicDisplay.registryAccess(), tagKey, EntryStacks::ofFluidHolder);
    }

    public static EntryIngredient ofItemsHolderSet(HolderSet<Item> stacks) {
        return (EntryIngredient)stacks.unwrap().map(EntryIngredients::ofItemTag, holders -> EntryIngredients.from(holders, EntryStacks::ofItemHolder));
    }

    public static EntryIngredient ofFluidHolderSet(HolderSet<Fluid> stacks) {
        return (EntryIngredient)stacks.unwrap().map(EntryIngredients::ofFluidTag, holders -> EntryIngredients.from(holders, EntryStacks::ofFluidHolder));
    }

    public static EntryIngredient ofSlotDisplay(SlotDisplay slot) {
        SlotDisplay slotDisplay = slot;
        Objects.requireNonNull(slotDisplay);
        SlotDisplay slotDisplay2 = slotDisplay;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SlotDisplay.Empty.class, SlotDisplay.ItemSlotDisplay.class, SlotDisplay.ItemStackSlotDisplay.class, SlotDisplay.TagSlotDisplay.class, SlotDisplay.Composite.class, SlotDisplay.AnyFuel.class}, (Object)slotDisplay2, n)) {
            case 0 -> {
                EntryIngredient var3_4;
                SlotDisplay.Empty $ = (SlotDisplay.Empty)slotDisplay2;
                yield var3_4 = EntryIngredient.empty();
            }
            case 1 -> {
                EntryIngredient var3_5;
                SlotDisplay.ItemSlotDisplay s = (SlotDisplay.ItemSlotDisplay)slotDisplay2;
                yield var3_5 = EntryIngredients.ofItemHolder((Holder<? extends ItemLike>)s.item());
            }
            case 2 -> {
                EntryIngredient var3_6;
                SlotDisplay.ItemStackSlotDisplay s = (SlotDisplay.ItemStackSlotDisplay)slotDisplay2;
                yield var3_6 = EntryIngredients.of(s.stack());
            }
            case 3 -> {
                EntryIngredient var3_7;
                SlotDisplay.TagSlotDisplay s = (SlotDisplay.TagSlotDisplay)slotDisplay2;
                yield var3_7 = EntryIngredients.ofItemTag(s.tag());
            }
            case 4 -> {
                EntryIngredient var3_8;
                SlotDisplay.Composite s = (SlotDisplay.Composite)slotDisplay2;
                EntryIngredient.Builder builder = EntryIngredient.builder();
                for (SlotDisplay slotDisplay : s.contents()) {
                    builder.addAll(EntryIngredients.ofSlotDisplay(slotDisplay));
                }
                yield var3_8 = builder.build();
            }
            case 5 -> {
                EntryIngredient var3_9;
                SlotDisplay.AnyFuel s = (SlotDisplay.AnyFuel)slotDisplay2;
                yield var3_9 = EntryIngredient.empty();
            }
            default -> {
                RegistryAccess access = Internals.getRegistryAccess();
                try {
                    EntryIngredient var3_10;
                    yield var3_10 = EntryIngredients.ofItemStacks(slot.resolveForStacks(new ContextMap.Builder().withParameter(SlotDisplayContext.REGISTRIES, (Object)access).create(SlotDisplayContext.CONTEXT)));
                }
                catch (Exception e) {
                    EntryIngredient var3_11;
                    InternalLogger.getInstance().warn("Failed to resolve slot display: " + String.valueOf(slot), e);
                    yield var3_11 = EntryIngredient.empty();
                }
            }
        };
    }

    public static List<EntryIngredient> ofSlotDisplays(Iterable<SlotDisplay> slots) {
        Collection collection;
        if (slots instanceof Collection && (collection = (Collection)slots).isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder ingredients = ImmutableList.builder();
        for (SlotDisplay slot : slots) {
            ingredients.add((Object)EntryIngredients.ofSlotDisplay(slot));
        }
        return ingredients.build();
    }

    public static <T> boolean testFuzzy(EntryIngredient ingredient, EntryStack<T> stack) {
        for (EntryStack ingredientStack : ingredient) {
            if (!EntryStacks.equalsFuzzy(ingredientStack, stack)) continue;
            return true;
        }
        return false;
    }
}

