/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.registry.display;

import java.util.Collection;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.rei.api.client.registry.display.reason.DisplayAdditionReason;
import me.shedaniel.rei.api.client.registry.display.reason.DisplayAdditionReasons;
import me.shedaniel.rei.api.common.display.Display;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface DisplayConsumer {
    default public void add(Display display) {
        this.add(display, null);
    }

    public boolean add(Display var1, @Nullable Object var2);

    default public void add(Object object) {
        this.addWithReason(object, DisplayAdditionReason.NONE);
    }

    @ApiStatus.Experimental
    default public void addWithReason(Object object, DisplayAdditionReason ... reasons) {
        if (object instanceof Display) {
            this.add((Display)object, null);
        } else {
            for (Display display : this.tryFillDisplay(object, reasons)) {
                this.add(display, object);
            }
        }
    }

    default public <T> Collection<Display> tryFillDisplay(T value) {
        return this.tryFillDisplay(value, DisplayAdditionReason.NONE);
    }

    @ApiStatus.Experimental
    public <T> Collection<Display> tryFillDisplay(T var1, DisplayAdditionReason ... var2);

    default public <T, D extends Display> FillerBuilder<T, D> beginFiller(Class<T> typeClass) {
        return new FillerBuilder(this, null, null).filterClass(typeClass);
    }

    @ApiStatus.Internal
    public <D extends Display> void registerFillerWithReason(BiPredicate<?, DisplayAdditionReasons> var1, BiFunction<?, DisplayAdditionReasons, @Nullable D> var2);

    @ApiStatus.Internal
    public <D extends Display> void registerDisplaysFillerWithReason(BiPredicate<?, DisplayAdditionReasons> var1, BiFunction<?, DisplayAdditionReasons, @Nullable Collection<? extends D>> var2);

    public static class FillerBuilder<T, D extends Display> {
        private final DisplayConsumer consumer;
        @Nullable
        private final BiPredicate<?, DisplayAdditionReasons> predicate;
        @Nullable
        private final BiFunction<?, DisplayAdditionReasons, Collection<D>> filler;

        private FillerBuilder(DisplayConsumer consumer, @Nullable BiPredicate<?, DisplayAdditionReasons> predicate, @Nullable BiFunction<?, DisplayAdditionReasons, Collection<D>> filler) {
            this.consumer = consumer;
            this.predicate = predicate;
            this.filler = filler;
        }

        public <T1> FillerBuilder<T1, D> filterClass(Class<T1> typeClass) {
            return new FillerBuilder<T, D>(this.consumer, this.newPredicate(typeClass::isInstance), this.filler);
        }

        public FillerBuilder<T, D> filter(Predicate<T> predicate) {
            return new FillerBuilder<T, D>(this.consumer, this.newPredicate(predicate), this.filler);
        }

        public FillerBuilder<T, D> filterWithReason(BiPredicate<T, DisplayAdditionReasons> predicate) {
            return new FillerBuilder<T, D>(this.consumer, this.newPredicate(predicate), this.filler);
        }

        public void fill(Function<T, D> filler) {
            this.consumer.registerFillerWithReason((o, r) -> this.predicate == null || this.predicate.test(o, (DisplayAdditionReasons)r), (o, r) -> (Display)filler.apply(o));
        }

        public void fillWithReason(BiFunction<T, DisplayAdditionReasons, D> filler) {
            this.consumer.registerFillerWithReason((o, r) -> this.predicate == null || this.predicate.test(o, (DisplayAdditionReasons)r), filler);
        }

        public void fillMultiple(Function<T, ? extends Collection<? extends D>> filler) {
            this.consumer.registerDisplaysFillerWithReason((o, r) -> this.predicate == null || this.predicate.test(o, (DisplayAdditionReasons)r), (o, r) -> (Collection)filler.apply(o));
        }

        public void fillMultipleWithReason(BiFunction<T, DisplayAdditionReasons, ? extends Collection<? extends D>> filler) {
            this.consumer.registerDisplaysFillerWithReason((o, r) -> this.predicate == null || this.predicate.test(o, (DisplayAdditionReasons)r), (o, r) -> (Collection)filler.apply((Object)o, (DisplayAdditionReasons)r));
        }

        private BiPredicate<?, DisplayAdditionReasons> newPredicate(Predicate<?> predicate) {
            if (this.predicate == null) {
                return (o, r) -> predicate.test(o);
            }
            return this.predicate.and((o, r) -> predicate.test(o));
        }

        private BiPredicate<?, DisplayAdditionReasons> newPredicate(BiPredicate<?, DisplayAdditionReasons> predicate) {
            if (this.predicate == null) {
                return predicate;
            }
            return this.predicate.and(predicate);
        }
    }

    public static interface RecipeManagerConsumer
    extends DisplayConsumer {
        default public <T extends Recipe<?>, D extends Display> RecipeFillerBuilder<T, D> beginRecipeFiller(Class<T> typeClass) {
            return new RecipeFillerBuilder(this, null, null).filterClass(typeClass);
        }

        public static class RecipeFillerBuilder<T extends Recipe<?>, D extends Display> {
            private final DisplayConsumer consumer;
            @Nullable
            private final BiPredicate<RecipeHolder<?>, DisplayAdditionReasons> predicate;
            @Nullable
            private final BiFunction<RecipeHolder<?>, DisplayAdditionReasons, Collection<D>> filler;

            private RecipeFillerBuilder(DisplayConsumer consumer, @Nullable BiPredicate<RecipeHolder<?>, DisplayAdditionReasons> predicate, @Nullable BiFunction<RecipeHolder<?>, DisplayAdditionReasons, Collection<D>> filler) {
                this.consumer = consumer;
                this.predicate = predicate;
                this.filler = filler;
            }

            public <T1 extends Recipe<?>> RecipeFillerBuilder<T1, D> filterClass(Class<T1> typeClass) {
                return new RecipeFillerBuilder<T, D>(this.consumer, this.newPredicate((? extends RecipeHolder<?> o) -> typeClass.isInstance(o.value())), this.filler);
            }

            public RecipeFillerBuilder<T, D> filter(Predicate<RecipeHolder<T>> predicate) {
                return new RecipeFillerBuilder<T, D>(this.consumer, this.newPredicate(predicate), this.filler);
            }

            public RecipeFillerBuilder<T, D> filterWithReason(BiPredicate<RecipeHolder<T>, DisplayAdditionReasons> predicate) {
                return new RecipeFillerBuilder<T, D>(this.consumer, this.newPredicate(predicate), this.filler);
            }

            public RecipeFillerBuilder<T, D> filterType(RecipeType<? super T> type) {
                return new RecipeFillerBuilder<T, D>(this.consumer, this.newPredicate((? extends RecipeHolder<?> o) -> o.value().getType() == type), this.filler);
            }

            public RecipeFillerBuilder<T, D> filterType(Predicate<RecipeType<? super T>> predicate) {
                return new RecipeFillerBuilder<T, D>(this.consumer, this.newPredicate((? extends RecipeHolder<?> o) -> predicate.test(o.value().getType())), this.filler);
            }

            public void fill(Function<RecipeHolder<T>, D> filler) {
                this.consumer.registerFillerWithReason((o, r) -> {
                    if (o instanceof RecipeHolder) {
                        RecipeHolder holder = (RecipeHolder)o;
                        return this.predicate == null || this.predicate.test((RecipeHolder<?>)holder, (DisplayAdditionReasons)r);
                    }
                    return false;
                }, (o, r) -> (Display)filler.apply((RecipeHolder)o));
            }

            public void fillWithReason(BiFunction<RecipeHolder<T>, DisplayAdditionReasons, D> filler) {
                this.consumer.registerFillerWithReason((o, r) -> {
                    if (o instanceof RecipeHolder) {
                        RecipeHolder holder = (RecipeHolder)o;
                        return this.predicate == null || this.predicate.test((RecipeHolder<?>)holder, (DisplayAdditionReasons)r);
                    }
                    return false;
                }, (o, r) -> (Display)filler.apply((RecipeHolder)((RecipeHolder)o), (DisplayAdditionReasons)r));
            }

            public void fillMultiple(Function<RecipeHolder<T>, ? extends Collection<? extends D>> filler) {
                this.consumer.registerDisplaysFillerWithReason((o, r) -> {
                    if (o instanceof RecipeHolder) {
                        RecipeHolder holder = (RecipeHolder)o;
                        return this.predicate == null || this.predicate.test((RecipeHolder<?>)holder, (DisplayAdditionReasons)r);
                    }
                    return false;
                }, (o, r) -> (Collection)filler.apply((RecipeHolder)o));
            }

            public void fillMultipleWithReason(BiFunction<RecipeHolder<T>, DisplayAdditionReasons, ? extends Collection<? extends D>> filler) {
                this.consumer.registerDisplaysFillerWithReason((o, r) -> {
                    if (o instanceof RecipeHolder) {
                        RecipeHolder holder = (RecipeHolder)o;
                        return this.predicate == null || this.predicate.test((RecipeHolder<?>)holder, (DisplayAdditionReasons)r);
                    }
                    return false;
                }, (o, r) -> (Collection)filler.apply((RecipeHolder)((RecipeHolder)o), (DisplayAdditionReasons)r));
            }

            private BiPredicate<RecipeHolder<?>, DisplayAdditionReasons> newPredicate(Predicate<? extends RecipeHolder<?>> predicate) {
                if (this.predicate == null) {
                    return (o, r) -> predicate.test((RecipeHolder<?>)o);
                }
                return this.predicate.and((o, r) -> predicate.test((RecipeHolder<?>)o));
            }

            private BiPredicate<RecipeHolder<?>, DisplayAdditionReasons> newPredicate(BiPredicate<? extends RecipeHolder<?>, DisplayAdditionReasons> predicate) {
                if (this.predicate == null) {
                    return predicate;
                }
                return this.predicate.and(predicate);
            }
        }
    }

    public static interface RecipeDisplayConsumer
    extends DisplayConsumer {
        default public <T extends RecipeDisplay, D extends Display> RecipeFillerBuilder<T, D> beginRecipeFiller(Class<T> typeClass) {
            return new RecipeFillerBuilder(this, null, null).filterClass(typeClass);
        }

        public static class RecipeFillerBuilder<T extends RecipeDisplay, D extends Display> {
            private final DisplayConsumer consumer;
            @Nullable
            private final BiPredicate<?, DisplayAdditionReasons> predicate;
            @Nullable
            private final BiFunction<?, DisplayAdditionReasons, Collection<D>> filler;

            private RecipeFillerBuilder(DisplayConsumer consumer, @Nullable BiPredicate<?, DisplayAdditionReasons> predicate, @Nullable BiFunction<?, DisplayAdditionReasons, Collection<D>> filler) {
                this.consumer = consumer;
                this.predicate = predicate;
                this.filler = filler;
            }

            public <T1 extends RecipeDisplay> RecipeFillerBuilder<T1, D> filterClass(Class<T1> typeClass) {
                return new RecipeFillerBuilder<T, D>(this.consumer, this.newPredicate(typeClass::isInstance), this.filler);
            }

            public RecipeFillerBuilder<T, D> filter(Predicate<T> predicate) {
                return new RecipeFillerBuilder<T, D>(this.consumer, this.newPredicate(predicate), this.filler);
            }

            public RecipeFillerBuilder<T, D> filterWithReason(BiPredicate<T, DisplayAdditionReasons> predicate) {
                return new RecipeFillerBuilder<T, D>(this.consumer, this.newPredicate(predicate), this.filler);
            }

            public RecipeFillerBuilder<T, D> filter(PredicateWithId<T> predicate) {
                return new RecipeFillerBuilder<T, D>(this.consumer, this.newPredicate((? o, DisplayAdditionReasons r) -> predicate.test((RecipeDisplay)o, Optional.ofNullable((DisplayAdditionReason.WithId)((Object)r.get(DisplayAdditionReason.WithId.class))).map(DisplayAdditionReason.WithId::id))), this.filler);
            }

            public RecipeFillerBuilder<T, D> filterWithReason(BiPredicateWithId<T, DisplayAdditionReasons> predicate) {
                return new RecipeFillerBuilder<T, D>(this.consumer, this.newPredicate((? o, DisplayAdditionReasons r) -> predicate.test((Object)((RecipeDisplay)o), (DisplayAdditionReasons)r, Optional.ofNullable((DisplayAdditionReason.WithId)((Object)r.get(DisplayAdditionReason.WithId.class))).map(DisplayAdditionReason.WithId::id))), this.filler);
            }

            public RecipeFillerBuilder<T, D> filterType(RecipeDisplay.Type<? super T> type) {
                return new RecipeFillerBuilder<T, D>(this.consumer, this.newPredicate((? o) -> {
                    RecipeDisplay d;
                    return o instanceof RecipeDisplay && (d = (RecipeDisplay)o).type() == type;
                }), this.filler);
            }

            public RecipeFillerBuilder<T, D> filterType(Predicate<RecipeDisplay.Type<? super T>> predicate) {
                return new RecipeFillerBuilder<T, D>(this.consumer, this.newPredicate((? o) -> {
                    RecipeDisplay d;
                    return o instanceof RecipeDisplay && predicate.test((d = (RecipeDisplay)o).type());
                }), this.filler);
            }

            public void fill(FunctionWithId<T, D> filler) {
                this.consumer.registerFillerWithReason((o, r) -> this.predicate == null || this.predicate.test(o, (DisplayAdditionReasons)r), (o, r) -> (Display)filler.apply((RecipeDisplay)o, Optional.ofNullable((DisplayAdditionReason.WithId)((Object)r.get(DisplayAdditionReason.WithId.class))).map(DisplayAdditionReason.WithId::id)));
            }

            public void fillWithReason(BiFunctionWithId<T, DisplayAdditionReasons, D> filler) {
                this.consumer.registerFillerWithReason((o, r) -> this.predicate == null || this.predicate.test(o, (DisplayAdditionReasons)r), (o, r) -> (Display)filler.apply((Object)((RecipeDisplay)o), (DisplayAdditionReasons)r, Optional.ofNullable((DisplayAdditionReason.WithId)((Object)r.get(DisplayAdditionReason.WithId.class))).map(DisplayAdditionReason.WithId::id)));
            }

            public void fillMultiple(FunctionWithId<T, ? extends Collection<? extends D>> filler) {
                this.consumer.registerDisplaysFillerWithReason((o, r) -> this.predicate == null || this.predicate.test(o, (DisplayAdditionReasons)r), (o, r) -> (Collection)filler.apply((RecipeDisplay)o, Optional.ofNullable((DisplayAdditionReason.WithId)((Object)r.get(DisplayAdditionReason.WithId.class))).map(DisplayAdditionReason.WithId::id)));
            }

            public void fillMultipleWithReason(BiFunctionWithId<T, DisplayAdditionReasons, ? extends Collection<? extends D>> filler) {
                this.consumer.registerDisplaysFillerWithReason((o, r) -> this.predicate == null || this.predicate.test(o, (DisplayAdditionReasons)r), (o, r) -> (Collection)filler.apply((Object)((RecipeDisplay)o), (DisplayAdditionReasons)r, Optional.ofNullable((DisplayAdditionReason.WithId)((Object)r.get(DisplayAdditionReason.WithId.class))).map(DisplayAdditionReason.WithId::id)));
            }

            private BiPredicate<?, DisplayAdditionReasons> newPredicate(Predicate<?> predicate) {
                if (this.predicate == null) {
                    return (o, r) -> predicate.test(o);
                }
                return this.predicate.and((o, r) -> predicate.test(o));
            }

            private BiPredicate<?, DisplayAdditionReasons> newPredicate(BiPredicate<?, DisplayAdditionReasons> predicate) {
                if (this.predicate == null) {
                    return predicate;
                }
                return this.predicate.and(predicate);
            }
        }
    }

    @FunctionalInterface
    public static interface BiPredicateWithId<T, U> {
        public boolean test(T var1, U var2, Optional<RecipeDisplayId> var3);
    }

    @FunctionalInterface
    public static interface PredicateWithId<T> {
        public boolean test(T var1, Optional<RecipeDisplayId> var2);
    }

    @FunctionalInterface
    public static interface BiFunctionWithId<T, U, R> {
        public R apply(T var1, U var2, Optional<RecipeDisplayId> var3);
    }

    @FunctionalInterface
    public static interface FunctionWithId<T, R> {
        public R apply(T var1, Optional<RecipeDisplayId> var2);
    }
}

