/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.drag;

import java.util.stream.StreamSupport;
import me.shedaniel.math.Rectangle;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@FunctionalInterface
public interface DraggableBoundsProvider {
    public static VoxelShape fromRectangle(Rectangle bounds) {
        return Shapes.box((double)bounds.x, (double)bounds.y, (double)0.0, (double)bounds.getMaxX(), (double)bounds.getMaxY(), (double)0.1);
    }

    public static DraggableBoundsProvider ofRectangle(Rectangle bounds) {
        return DraggableBoundsProvider.ofShape(DraggableBoundsProvider.fromRectangle(bounds));
    }

    public static DraggableBoundsProvider ofRectangles(Iterable<Rectangle> bounds) {
        VoxelShape shape = StreamSupport.stream(bounds.spliterator(), false).map(DraggableBoundsProvider::fromRectangle).reduce(Shapes.empty(), Shapes::or);
        return DraggableBoundsProvider.ofShape(shape);
    }

    public static DraggableBoundsProvider ofShape(VoxelShape shape) {
        return () -> shape;
    }

    public static DraggableBoundsProvider ofShapes(Iterable<VoxelShape> shapes) {
        VoxelShape shape = StreamSupport.stream(shapes.spliterator(), false).reduce(Shapes.empty(), Shapes::or);
        return DraggableBoundsProvider.ofShape(shape);
    }

    public static DraggableBoundsProvider empty() {
        return Shapes::empty;
    }

    public static DraggableBoundsProvider concat(Iterable<DraggableBoundsProvider> providers) {
        return () -> StreamSupport.stream(providers.spliterator(), false).map(DraggableBoundsProvider::bounds).reduce(Shapes.empty(), Shapes::or);
    }

    public VoxelShape bounds();
}

