/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.api.common.transfer.info.stack;

import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.REICommonPlugin;
import me.shedaniel.rei.api.common.registry.Reloadable;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.function.Predicate;

@ApiStatus.Experimental
public interface SlotAccessorRegistry extends Reloadable<REICommonPlugin> {
    /**
     * @return the instance of {@link SlotAccessorRegistry}
     */
    static SlotAccessorRegistry getInstance() {
        return PluginManager.getInstance().get(SlotAccessorRegistry.class);
    }
    
    void register(class_2960 id, Predicate<SlotAccessor> accessorPredicate, Serializer serializer);
    
    @Nullable
    Serializer get(class_2960 id);
    
    class_2487 save(class_1703 menu, class_1657 player, SlotAccessor accessor);
    
    SlotAccessor read(class_1703 menu, class_1657 player, class_2487 tag);
    
    interface Serializer {
        SlotAccessor read(class_1703 menu, class_1657 player, class_2487 tag);
        
        @Nullable
        class_2487 save(class_1703 menu, class_1657 player, SlotAccessor accessor);
    }
}
