/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.client.gui.forge;

import dev.architectury.platform.hooks.EventBusesHooks;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.neoforged.bus.api.EventPriority;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ClientTooltipComponentRegistryImpl {
    @Nullable
    private static List<Entry<?>> entries = new ArrayList();

    public static <T extends TooltipComponent> void register(Class<T> clazz, Function<? super T, ? extends ClientTooltipComponent> factory) {
        if (entries == null) {
            throw new IllegalStateException("Cannot register ClientTooltipComponent factory when factories are already aggregated!");
        }
        entries.add(new Entry<T>(clazz, factory));
    }

    static {
        EventBusesHooks.whenAvailable("architectury", bus -> bus.addListener(EventPriority.HIGH, event -> {
            if (entries != null) {
                Iterator<Entry<?>> iterator = entries.iterator();
                while (iterator.hasNext()) {
                    Entry<?> entry;
                    Entry<?> casted = entry = iterator.next();
                    event.register(casted.clazz(), casted.factory());
                }
                entries = null;
            }
        }));
    }

    public record Entry<T extends TooltipComponent>(Class<T> clazz, Function<? super T, ? extends ClientTooltipComponent> factory) {
    }
}

