/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.hooks.client.fluid.forge;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import org.jetbrains.annotations.Nullable;

public class ClientFluidStackHooksImpl {
    @Nullable
    public static TextureAtlasSprite getStillTexture(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, FluidState state) {
        if (state.getType() == Fluids.EMPTY) {
            return null;
        }
        Identifier texture = IClientFluidTypeExtensions.of((FluidState)state).getStillTexture(state, level, pos);
        return Minecraft.getInstance().getAtlasManager().get(new Material(TextureAtlas.LOCATION_BLOCKS, texture));
    }

    @Nullable
    public static TextureAtlasSprite getStillTexture(FluidStack stack) {
        if (stack.getFluid() == Fluids.EMPTY) {
            return null;
        }
        Identifier texture = IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getStillTexture(FluidStackHooksForge.toForge(stack));
        return Minecraft.getInstance().getAtlasManager().get(new Material(TextureAtlas.LOCATION_BLOCKS, texture));
    }

    @Nullable
    public static TextureAtlasSprite getStillTexture(Fluid fluid) {
        if (fluid == Fluids.EMPTY) {
            return null;
        }
        Identifier texture = IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture();
        return Minecraft.getInstance().getAtlasManager().get(new Material(TextureAtlas.LOCATION_BLOCKS, texture));
    }

    @Nullable
    public static TextureAtlasSprite getFlowingTexture(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, FluidState state) {
        if (state.getType() == Fluids.EMPTY) {
            return null;
        }
        Identifier texture = IClientFluidTypeExtensions.of((FluidState)state).getFlowingTexture(state, level, pos);
        return Minecraft.getInstance().getAtlasManager().get(new Material(TextureAtlas.LOCATION_BLOCKS, texture));
    }

    @Nullable
    public static TextureAtlasSprite getFlowingTexture(FluidStack stack) {
        if (stack.getFluid() == Fluids.EMPTY) {
            return null;
        }
        Identifier texture = IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getFlowingTexture(FluidStackHooksForge.toForge(stack));
        return Minecraft.getInstance().getAtlasManager().get(new Material(TextureAtlas.LOCATION_BLOCKS, texture));
    }

    @Nullable
    public static TextureAtlasSprite getFlowingTexture(Fluid fluid) {
        if (fluid == Fluids.EMPTY) {
            return null;
        }
        Identifier texture = IClientFluidTypeExtensions.of((Fluid)fluid).getFlowingTexture();
        return Minecraft.getInstance().getAtlasManager().get(new Material(TextureAtlas.LOCATION_BLOCKS, texture));
    }

    public static int getColor(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, FluidState state) {
        if (state.getType() == Fluids.EMPTY) {
            return -1;
        }
        return IClientFluidTypeExtensions.of((FluidState)state).getTintColor(state, level, pos);
    }

    public static int getColor(FluidStack stack) {
        if (stack.getFluid() == Fluids.EMPTY) {
            return -1;
        }
        return IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getTintColor(FluidStackHooksForge.toForge(stack));
    }

    public static int getColor(Fluid fluid) {
        if (fluid == Fluids.EMPTY) {
            return -1;
        }
        return IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor();
    }
}

