/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.fluid.forge;

import dev.architectury.core.fluid.ArchitecturyFluidAttributes;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.client.forge.ClientExtensionsRegistryImpl;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class ArchitecturyFluidAttributesClient {
    public static void registerClient(FluidType fluid, Supplier<ArchitecturyFluidAttributes> attributes) {
        ClientExtensionsRegistryImpl.register(event -> {
            if (event != null) {
                event.registerFluidType(ArchitecturyFluidAttributesClient.initializeClient((ArchitecturyFluidAttributes)attributes.get()), new FluidType[]{fluid});
            } else {
                try {
                    Class<?> clazz = Class.forName("net.neoforged.neoforge.client.extensions.common.ClientExtensionsManager");
                    Field field = clazz.getDeclaredField("FLUID_TYPE_EXTENSIONS");
                    field.setAccessible(true);
                    Method method = clazz.getDeclaredMethod("register", Object.class, Map.class, Object[].class);
                    method.setAccessible(true);
                    method.invoke(null, ArchitecturyFluidAttributesClient.initializeClient((ArchitecturyFluidAttributes)attributes.get()), (Map)field.get(null), new Object[]{fluid});
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static IClientFluidTypeExtensions initializeClient(final ArchitecturyFluidAttributes attributes) {
        return new IClientFluidTypeExtensions(){

            public int getTintColor() {
                return attributes.getColor();
            }

            public Identifier getStillTexture() {
                return attributes.getSourceTexture();
            }

            public Identifier getFlowingTexture() {
                return attributes.getFlowingTexture();
            }

            @Nullable
            public Identifier getOverlayTexture() {
                return attributes.getOverlayTexture();
            }

            public Identifier getStillTexture(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                return attributes.getSourceTexture(state, getter, pos);
            }

            public Identifier getFlowingTexture(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                return attributes.getFlowingTexture(state, getter, pos);
            }

            @Nullable
            public Identifier getOverlayTexture(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                return attributes.getOverlayTexture(state, getter, pos);
            }

            public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                return attributes.getColor(state, getter, pos);
            }

            public int getTintColor(net.neoforged.neoforge.fluids.FluidStack stack) {
                return attributes.getColor(ArchitecturyFluidAttributesClient.convertSafe(stack));
            }

            public Identifier getStillTexture(net.neoforged.neoforge.fluids.FluidStack stack) {
                return attributes.getSourceTexture(ArchitecturyFluidAttributesClient.convertSafe(stack));
            }

            public Identifier getFlowingTexture(net.neoforged.neoforge.fluids.FluidStack stack) {
                return attributes.getFlowingTexture(ArchitecturyFluidAttributesClient.convertSafe(stack));
            }

            @Nullable
            public Identifier getOverlayTexture(net.neoforged.neoforge.fluids.FluidStack stack) {
                return attributes.getOverlayTexture(ArchitecturyFluidAttributesClient.convertSafe(stack));
            }
        };
    }

    @Nullable
    public static FluidStack convertSafe(@Nullable net.neoforged.neoforge.fluids.FluidStack stack) {
        return stack == null ? null : FluidStackHooksForge.fromForge(stack);
    }

    @Nullable
    public static FluidStack convertSafe(@Nullable FluidState state) {
        return state == null ? null : FluidStack.create(state.getType(), FluidStack.bucketAmount());
    }
}

