/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.registry.forge;

import dev.architectury.registry.client.forge.ClientReloadListenerRegistryImpl;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ReloadListenerRegistryImpl {
    private static Map<Identifier, PreparableReloadListener> serverDataReloadListeners = new HashMap<>();
    private static Map<Identifier, Collection<Identifier>> serverDataReloadListenerDependencies = new HashMap<>();
    
    static {
        NeoForge.EVENT_BUS.addListener(ReloadListenerRegistryImpl::addServerReloadListeners);
    }
    
    public static void register(PackType type, PreparableReloadListener listener, Identifier listenerId, Collection<Identifier> dependencies) {
        if (type == PackType.SERVER_DATA) {
            serverDataReloadListeners.put(listenerId, listener);
            serverDataReloadListenerDependencies.put(listenerId, dependencies);
        } else if (type == PackType.CLIENT_RESOURCES) {
            ClientReloadListenerRegistryImpl.register(listener, listenerId, dependencies);
        }
    }

    public static void addServerReloadListeners(AddServerReloadListenersEvent event) {
        serverDataReloadListeners.forEach(event::addListener);
        serverDataReloadListenerDependencies.forEach((listener, dependencies) -> dependencies.forEach(dependency -> event.addDependency(listener, dependency)));
    }
}
