/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.event.events.client;

import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import net.minecraft.network.protocol.game.ClientboundRecipeBookAddPacket;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import org.jetbrains.annotations.ApiStatus;

import java.util.List;

public interface ClientRecipeUpdateEvent {
    /**
     * @see ClientRecipeUpdateEvent#update(RecipeAccess)
     */
    Event<ClientRecipeUpdateEvent> EVENT = EventFactory.createLoop();
    
    /**
     * @see ClientRecipeUpdateEvent.Add#add(RecipeAccess, List)
     */
    @ApiStatus.Experimental
    Event<Add> ADD = EventFactory.createLoop();
    
    /**
     * @see ClientRecipeUpdateEvent.Remove#remove(RecipeAccess, List)
     */
    @ApiStatus.Experimental
    Event<Remove> REMOVE = EventFactory.createLoop();
    
    /**
     * Invoked when the client has received an updated list of recipes from the server.
     * Equivalent to Forge's {@code RecipesUpdatedEvent} event.
     *
     * @param recipeAccess The recipe access.
     */
    void update(RecipeAccess recipeAccess);
    
    @ApiStatus.Experimental
    interface Add {
        void add(RecipeAccess recipeAccess, List<ClientboundRecipeBookAddPacket.Entry> entries);
    }
    
    @ApiStatus.Experimental
    interface Remove {
        void remove(RecipeAccess recipeAccess, List<RecipeDisplayId> ids);
    }
}
