/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.core.item.forge.imitator;

import dev.architectury.hooks.fluid.FluidBucketHooks;
import dev.architectury.platform.hooks.EventBusesHooks;
import dev.architectury.utils.ArchitecturyConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.transfer.fluid.BucketResourceHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.function.Supplier;

public class ArchitecturyBucketItem extends BucketItem {
    private static final Logger LOGGER = LogManager.getLogger(ArchitecturyBucketItem.class);
    
    public ArchitecturyBucketItem(Supplier<? extends Fluid> fluid, Properties properties) {
        super(fluid.get(), properties);
        EventBusesHooks.whenAvailable(ArchitecturyConstants.MOD_ID, bus -> {
            bus.<RegisterCapabilitiesEvent>addListener(event -> {
                if (BuiltInRegistries.ITEM.containsValue(this)) {
                    event.registerItem(Capabilities.Fluid.ITEM, (stack, access) -> new BucketResourceHandler(access), this);
                } else {
                    LOGGER.warn("Tried to register a bucket item capability for an item that is not registered: {}", this);
                }
            });
        });
    }
    
    public final Fluid getContainedFluid() {
        return FluidBucketHooks.getFluid(this);
    }
}
