/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.fuel.forge;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.FuelValues;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.furnace.FurnaceFuelBurnTimeEvent;
import org.jetbrains.annotations.Nullable;

public class FuelRegistryImpl {
    private static final Object2IntMap<ItemLike> ITEMS = new Object2IntLinkedOpenHashMap();

    public static void register(int time, ItemLike ... items) {
        for (ItemLike item : items) {
            ITEMS.put((Object)item, time);
        }
    }

    public static int get(ItemStack stack, @Nullable RecipeType<?> recipeType, FuelValues fuelValues) {
        return stack.getBurnTime(recipeType, fuelValues);
    }

    @SubscribeEvent
    public static void event(FurnaceFuelBurnTimeEvent event) {
        if (event.getItemStack().isEmpty()) {
            return;
        }
        int time = ITEMS.getOrDefault((Object)event.getItemStack().getItem(), Integer.MIN_VALUE);
        if (time != Integer.MIN_VALUE) {
            event.setBurnTime(time);
        }
    }

    static {
        NeoForge.EVENT_BUS.register(FuelRegistryImpl.class);
    }
}

