/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking.forge.client;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.transformers.PacketSink;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ClientNetworkManagerImpl {
    public static Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    public static RegistryAccess getClientRegistryAccess() {
        if (Minecraft.getInstance().level != null) {
            return Minecraft.getInstance().level.registryAccess();
        }
        if (Minecraft.getInstance().getConnection() != null) {
            return Minecraft.getInstance().getConnection().registryAccess();
        }
        if (Minecraft.getInstance().gameMode != null) {
            return Minecraft.getInstance().gameMode.connection.registryAccess();
        }
        return RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
    }

    public static boolean canServerReceive(ResourceLocation id) {
        if (Minecraft.getInstance().getConnection() != null) {
            return Minecraft.getInstance().getConnection().hasChannel(id);
        }
        return false;
    }

    public static <T extends CustomPacketPayload> void sendToServer(T payload) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection == null) {
            return;
        }
        NetworkManager.collectPackets(PacketSink.client(), NetworkManager.clientToServer(), payload, (RegistryAccess)connection.registryAccess());
    }
}

