/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.hooks.fluid.forge;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FluidStackHooksImpl {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static Component getName(FluidStack stack) {
        return stack.getFluid().getFluidType().getDescription(FluidStackHooksForge.toForge(stack));
    }

    public static String getTranslationKey(FluidStack stack) {
        return stack.getFluid().getFluidType().getDescriptionId(FluidStackHooksForge.toForge(stack));
    }

    public static FluidStack read(RegistryFriendlyByteBuf buf) {
        return (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buf);
    }

    public static void write(FluidStack stack, RegistryFriendlyByteBuf buf) {
        FluidStack.STREAM_CODEC.encode((Object)buf, (Object)stack);
    }

    public static Optional<FluidStack> read(HolderLookup.Provider provider, Tag tag) {
        return FluidStack.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(string -> LOGGER.error("Tried to load invalid fluid stack: '{}'", string));
    }

    public static FluidStack readOptional(HolderLookup.Provider provider, CompoundTag tag) {
        return tag.isEmpty() ? FluidStack.empty() : FluidStackHooksImpl.read(provider, (Tag)tag).orElse(FluidStack.empty());
    }

    public static Tag write(HolderLookup.Provider provider, FluidStack stack, Tag tag) {
        return (Tag)FluidStack.CODEC.encode((Object)stack, (DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).getOrThrow(IllegalStateException::new);
    }

    public static long bucketAmount() {
        return 1000L;
    }

    public static int getLuminosity(FluidStack fluid, @Nullable Level level, @Nullable BlockPos pos) {
        return fluid.getFluid().getFluidType().getLightLevel(FluidStackHooksForge.toForge(fluid));
    }

    @Deprecated(forRemoval=true)
    public static int getLuminosity(Fluid fluid, @Nullable Level level, @Nullable BlockPos pos) {
        if (level != null && pos != null) {
            FluidState state = level.getFluidState(pos);
            return fluid.getFluidType().getLightLevel(state, (BlockAndTintGetter)level, pos);
        }
        return fluid.getFluidType().getLightLevel();
    }

    public static int getTemperature(FluidStack fluid, @Nullable Level level, @Nullable BlockPos pos) {
        return fluid.getFluid().getFluidType().getTemperature(FluidStackHooksForge.toForge(fluid));
    }

    public static int getTemperature(Fluid fluid, @Nullable Level level, @Nullable BlockPos pos) {
        if (level != null && pos != null) {
            FluidState state = level.getFluidState(pos);
            return fluid.getFluidType().getTemperature(state, (BlockAndTintGetter)level, pos);
        }
        return fluid.getFluidType().getTemperature();
    }

    public static int getViscosity(FluidStack fluid, @Nullable Level level, @Nullable BlockPos pos) {
        return fluid.getFluid().getFluidType().getViscosity(FluidStackHooksForge.toForge(fluid));
    }

    public static int getViscosity(Fluid fluid, @Nullable Level level, @Nullable BlockPos pos) {
        if (level != null && pos != null) {
            FluidState state = level.getFluidState(pos);
            return fluid.getFluidType().getViscosity(state, (BlockAndTintGetter)level, pos);
        }
        return fluid.getFluidType().getViscosity();
    }
}

