/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge;

import com.google.common.base.Stopwatch;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingContext;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.DependencyInfo;
import net.fabricmc.loom.configuration.providers.forge.DependencyProvider;
import net.fabricmc.loom.configuration.providers.mappings.GradleMappingContext;
import net.fabricmc.loom.configuration.providers.mappings.mojmap.MojangMappingLayer;
import net.fabricmc.loom.configuration.providers.mappings.mojmap.MojangMappingsSpec;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.srg.Tsrg2Utils;
import net.fabricmc.loom.util.srg.Tsrg2Writer;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.ForwardingMappingVisitor;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.minecraftforge.installertools.ConsoleTool;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;

public class SrgProvider
extends DependencyProvider {
    private Path srg;
    private Boolean isTsrgV2;
    private Path mergedMojangRaw;
    private Path mergedMojang;
    private Path mergedMojangTrimmed;
    private static Map<String, Path> mojmapTsrgMap = new HashMap<String, Path>();
    private static Map<String, Path> mojmapTsrg2Map = new HashMap<String, Path>();

    public SrgProvider(Project project) {
        super(project);
    }

    @Override
    public void provide(DependencyInfo dependency) throws Exception {
        this.init(dependency.getDependency().getVersion());
        if (!Files.exists(this.srg, new LinkOption[0]) || this.refreshDeps()) {
            Path srgZip = dependency.resolveFile().orElseThrow(() -> new RuntimeException("Could not resolve srg")).toPath();
            Files.write(this.srg, ZipUtils.unpack(srgZip, "config/joined.tsrg"), new OpenOption[0]);
        }
        try (BufferedReader reader = Files.newBufferedReader(this.srg);){
            this.isTsrgV2 = reader.readLine().startsWith("tsrg2");
        }
        if (!(!this.isTsrgV2.booleanValue() || Files.exists(this.mergedMojangRaw, new LinkOption[0]) && Files.exists(this.mergedMojang, new LinkOption[0]) && Files.exists(this.mergedMojangTrimmed, new LinkOption[0]) && !this.refreshDeps())) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.getProject().getLogger().lifecycle(":merging mappings (InstallerTools, srg + mojmap)");
            PrintStream out = System.out;
            PrintStream err = System.err;
            if (this.getProject().getGradle().getStartParameter().getLogLevel().compareTo((Enum)LogLevel.LIFECYCLE) >= 0) {
                System.setOut(new PrintStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM));
                System.setErr(new PrintStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM));
            }
            Files.deleteIfExists(this.mergedMojangRaw);
            Files.deleteIfExists(this.mergedMojang);
            ConsoleTool.main((String[])new String[]{"--task", "MERGE_MAPPING", "--left", this.getSrg().toAbsolutePath().toString(), "--right", SrgProvider.getMojmapTsrg2(this.getProject(), this.getExtension()).toAbsolutePath().toString(), "--classes", "--output", this.mergedMojangRaw.toAbsolutePath().toString()});
            MemoryMappingTree tree = new MemoryMappingTree();
            MappingReader.read((Reader)new StringReader(FileUtils.readFileToString((File)this.mergedMojangRaw.toFile(), (Charset)StandardCharsets.UTF_8)), (MappingVisitor)new FieldDescWrappingVisitor((MappingVisitor)tree));
            Files.writeString(this.mergedMojang, (CharSequence)Tsrg2Writer.serialize((MappingTree)tree), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            for (MappingTree.ClassMapping classDef : tree.getClasses()) {
                for (MappingTree.MethodMapping methodDef : classDef.getMethods()) {
                    methodDef.getArgs().clear();
                }
            }
            Files.writeString(this.mergedMojangTrimmed, (CharSequence)Tsrg2Writer.serialize((MappingTree)tree), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            if (this.getProject().getGradle().getStartParameter().getLogLevel().compareTo((Enum)LogLevel.LIFECYCLE) >= 0) {
                System.setOut(out);
                System.setErr(err);
            }
            this.getProject().getLogger().lifecycle(":merged mappings (InstallerTools, srg + mojmap) in " + String.valueOf(stopwatch.stop()));
        }
    }

    private void init(String version) {
        File dir = this.getMinecraftProvider().dir("srg/" + version);
        this.srg = new File(dir, "srg.tsrg").toPath();
        this.mergedMojangRaw = new File(dir, "srg-mojmap-merged-raw.tsrg").toPath();
        this.mergedMojang = new File(dir, "srg-mojmap-merged.tsrg").toPath();
        this.mergedMojangTrimmed = new File(dir, "srg-mojmap-merged-trimmed.tsrg").toPath();
    }

    public Path getSrg() {
        return this.srg;
    }

    public Path getMergedMojangRaw() {
        if (!this.isTsrgV2()) {
            throw new IllegalStateException("May not access merged mojmap srg if not on modern Minecraft!");
        }
        return this.mergedMojangRaw;
    }

    public Path getMergedMojang() {
        if (!this.isTsrgV2()) {
            throw new IllegalStateException("May not access merged mojmap srg if not on modern Minecraft!");
        }
        return this.mergedMojang;
    }

    public Path getMergedMojangTrimmed() {
        if (!this.isTsrgV2()) {
            throw new IllegalStateException("May not access merged mojmap srg if not on modern Minecraft!");
        }
        return this.mergedMojangTrimmed;
    }

    public boolean isTsrgV2() {
        return this.isTsrgV2;
    }

    public static Path getMojmapTsrg(Project project, LoomGradleExtension extension) throws IOException {
        String minecraftVersion = extension.getMinecraftProvider().minecraftVersion();
        if (mojmapTsrgMap.containsKey(minecraftVersion)) {
            return mojmapTsrgMap.get(minecraftVersion);
        }
        Path mojmapTsrg = extension.getMinecraftProvider().dir("forge").toPath().resolve("mojmap.tsrg");
        if (Files.notExists(mojmapTsrg, new LinkOption[0]) || extension.refreshDeps()) {
            try (BufferedWriter writer = Files.newBufferedWriter(mojmapTsrg, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                GradleMappingContext context = new GradleMappingContext(project, "tmp-mojmap");
                Tsrg2Utils.writeTsrg(visitor -> SrgProvider.visitMojangMappings(visitor, context), MappingsNamespace.NAMED.toString(), false, writer);
            }
        }
        mojmapTsrgMap.put(minecraftVersion, mojmapTsrg);
        return mojmapTsrg;
    }

    public static Path getMojmapTsrg2(Project project, LoomGradleExtension extension) throws IOException {
        String minecraftVersion = extension.getMinecraftProvider().minecraftVersion();
        if (mojmapTsrg2Map.containsKey(minecraftVersion)) {
            return mojmapTsrg2Map.get(minecraftVersion);
        }
        Path mojmapTsrg2 = extension.getMinecraftProvider().dir("forge").toPath().resolve("mojmap.tsrg2");
        if (Files.notExists(mojmapTsrg2, new LinkOption[0]) || extension.refreshDeps()) {
            try (BufferedWriter writer = Files.newBufferedWriter(mojmapTsrg2, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                GradleMappingContext context = new GradleMappingContext(project, "tmp-mojmap");
                MemoryMappingTree tree = new MemoryMappingTree();
                SrgProvider.visitMojangMappings((MappingVisitor)tree, context);
                writer.write(Tsrg2Writer.serialize((MappingTree)tree));
            }
        }
        mojmapTsrg2Map.put(minecraftVersion, mojmapTsrg2);
        return mojmapTsrg2;
    }

    public static void visitMojangMappings(MappingVisitor visitor, MappingContext context) {
        try {
            MojangMappingLayer layer = new MojangMappingsSpec(() -> true, true).createLayer(context);
            layer.visit(visitor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String getTargetConfig() {
        return "srg";
    }

    private class FieldDescWrappingVisitor
    extends ForwardingMappingVisitor {
        private final Map<FieldKey, String> fieldDescMap;
        private String lastClass;

        protected FieldDescWrappingVisitor(MappingVisitor next) throws IOException {
            super(next);
            this.fieldDescMap = new HashMap<FieldKey, String>();
            MemoryMappingTree mojmap = new MemoryMappingTree();
            MappingReader.read((Path)SrgProvider.getMojmapTsrg2(SrgProvider.this.getProject(), SrgProvider.this.getExtension()), (MappingVisitor)mojmap);
            for (MappingTree.ClassMapping classMapping : mojmap.getClasses()) {
                for (MappingTree.FieldMapping fieldMapping : classMapping.getFields()) {
                    this.fieldDescMap.put(new FieldKey(classMapping.getSrcName(), fieldMapping.getSrcName()), fieldMapping.getSrcDesc());
                }
            }
        }

        public boolean visitClass(String srcName) throws IOException {
            if (super.visitClass(srcName)) {
                this.lastClass = srcName;
                return true;
            }
            return false;
        }

        public boolean visitField(String srcName, String srcDesc) throws IOException {
            if (srcDesc == null) {
                srcDesc = this.fieldDescMap.get(new FieldKey(this.lastClass, srcName));
            }
            return super.visitField(srcName, srcDesc);
        }

        private record FieldKey(String owner, String name) {
        }
    }
}

