/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.srg;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MappingTreeView;

public class Tsrg2Writer {
    public static String serialize(MappingTree tree) {
        List<String> namespaces = Stream.concat(Stream.of(tree.getSrcNamespace()), tree.getDstNamespaces().stream()).collect(Collectors.toList());
        StringBuilder builder = new StringBuilder();
        Tsrg2Writer.writeHeader(namespaces, builder);
        for (MappingTree.ClassMapping classMapping : tree.getClasses()) {
            Tsrg2Writer.writeClass(namespaces, classMapping, builder);
        }
        return builder.toString();
    }

    private static void writeClass(List<String> namespaces, MappingTree.ClassMapping def, StringBuilder builder) {
        Tsrg2Writer.writeMapped(null, namespaces, (MappingTreeView.ElementMappingView)def, builder);
        for (MappingTree.MethodMapping method : def.getMethods()) {
            Tsrg2Writer.writeMethod(namespaces, method, builder);
        }
        for (MappingTree.FieldMapping field : def.getFields()) {
            Tsrg2Writer.writeMapped(Character.valueOf('\t'), namespaces, (MappingTreeView.ElementMappingView)field, builder);
        }
    }

    private static void writeMethod(List<String> namespaces, MappingTree.MethodMapping def, StringBuilder builder) {
        Tsrg2Writer.writeMapped(Character.valueOf('\t'), namespaces, (MappingTreeView.ElementMappingView)def, builder);
        for (MappingTree.MethodArgMapping arg : def.getArgs()) {
            builder.append("\t\t").append(arg.getLvIndex());
            Tsrg2Writer.writeMapped(Character.valueOf(' '), namespaces, (MappingTreeView.ElementMappingView)arg, builder);
        }
    }

    private static void writeField(List<String> namespaces, MappingTree.FieldMapping def, StringBuilder builder) {
        Tsrg2Writer.writeMapped(Character.valueOf('\t'), namespaces, (MappingTreeView.ElementMappingView)def, builder);
    }

    private static void writeMapped(Character first, List<String> namespaces, MappingTreeView.ElementMappingView mapped, StringBuilder builder) {
        String[] names = (String[])namespaces.stream().map(arg_0 -> ((MappingTreeView.ElementMappingView)mapped).getName(arg_0)).toArray(String[]::new);
        for (int i = 0; i < names.length; ++i) {
            String descriptor;
            String name = names[i];
            if (i == 0) {
                if (first != null) {
                    builder.append(first);
                }
            } else {
                builder.append(' ');
            }
            builder.append(name);
            if (i != 0 || !(mapped instanceof MappingTreeView.MemberMappingView) || (descriptor = ((MappingTreeView.MemberMappingView)mapped).getSrcDesc()) == null || descriptor.isEmpty()) continue;
            builder.append(' ');
            builder.append(descriptor);
        }
        builder.append('\n');
    }

    private static void writeHeader(List<String> namespaces, StringBuilder builder) {
        builder.append("tsrg2");
        for (String namespace : namespaces) {
            builder.append(' ');
            builder.append(namespace);
        }
        builder.append('\n');
    }
}

