/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.srg;

import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvValidationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.stitch.commands.tinyv2.TinyClass;
import net.fabricmc.stitch.commands.tinyv2.TinyField;
import net.fabricmc.stitch.commands.tinyv2.TinyFile;
import net.fabricmc.stitch.commands.tinyv2.TinyMethod;
import net.fabricmc.stitch.commands.tinyv2.TinyMethodParameter;
import net.fabricmc.stitch.commands.tinyv2.TinyV2Reader;
import org.apache.commons.io.IOUtils;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.io.srg.tsrg.TSrgReader;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.FieldMapping;
import org.cadixdev.lorenz.model.InnerClassMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.cadixdev.lorenz.model.TopLevelClassMapping;
import org.jetbrains.annotations.Nullable;

public class MCPReader {
    private final Path intermediaryTinyPath;
    private final Path srgTsrgPath;

    public MCPReader(Path intermediaryTinyPath, Path srgTsrgPath) {
        this.intermediaryTinyPath = intermediaryTinyPath;
        this.srgTsrgPath = srgTsrgPath;
    }

    public TinyFile read(Path mcpJar) throws IOException {
        Map<MemberToken, String> srgTokens = this.readSrg();
        TinyFile intermediaryTiny = TinyV2Reader.read((Path)this.intermediaryTinyPath);
        Map<String, String> intermediaryToMCPMap = this.createIntermediaryToMCPMap(intermediaryTiny, srgTokens);
        HashMap<String, String[]> intermediaryToDocsMap = new HashMap<String, String[]>();
        HashMap<String, Map<Integer, String>> intermediaryToParamsMap = new HashMap<String, Map<Integer, String>>();
        try {
            this.injectMcp(mcpJar, intermediaryToMCPMap, intermediaryToDocsMap, intermediaryToParamsMap);
        }
        catch (CsvValidationException e) {
            throw new RuntimeException(e);
        }
        this.mergeTokensIntoIntermediary(intermediaryTiny, intermediaryToMCPMap, intermediaryToDocsMap, intermediaryToParamsMap);
        return intermediaryTiny;
    }

    private Map<String, String> createIntermediaryToMCPMap(TinyFile tiny, Map<MemberToken, String> officialToMCP) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (TinyClass tinyClass : tiny.getClassEntries()) {
            String classObf = (String)tinyClass.getMapping().get(0);
            String classIntermediary = (String)tinyClass.getMapping().get(1);
            MemberToken classTokenObf = MemberToken.ofClass(classObf);
            if (officialToMCP.containsKey(classTokenObf)) {
                map.put(classIntermediary, officialToMCP.get(classTokenObf));
            }
            for (TinyField tinyField : tinyClass.getFields()) {
                String fieldObf = (String)tinyField.getMapping().get(0);
                String fieldIntermediary = (String)tinyField.getMapping().get(1);
                MemberToken fieldTokenObf = MemberToken.ofField(classTokenObf, fieldObf);
                if (!officialToMCP.containsKey(fieldTokenObf)) continue;
                map.put(fieldIntermediary, officialToMCP.get(fieldTokenObf));
            }
            for (TinyMethod tinyMethod : tinyClass.getMethods()) {
                String methodObf = (String)tinyMethod.getMapping().get(0);
                String methodIntermediary = (String)tinyMethod.getMapping().get(1);
                MemberToken methodTokenObf = MemberToken.ofMethod(classTokenObf, methodObf, tinyMethod.getMethodDescriptorInFirstNamespace());
                if (!officialToMCP.containsKey(methodTokenObf)) continue;
                map.put(methodIntermediary, officialToMCP.get(methodTokenObf));
            }
        }
        return map;
    }

    private void mergeTokensIntoIntermediary(TinyFile tiny, Map<String, String> intermediaryToMCPMap, Map<String, String[]> intermediaryToDocsMap, Map<String, Map<Integer, String>> intermediaryToParamsMap) {
        this.stripTinyWithParametersAndLocal(tiny);
        tiny.getHeader().getNamespaces().add("named");
        for (TinyClass tinyClass : tiny.getClassEntries()) {
            String[] docs;
            String classIntermediary = (String)tinyClass.getMapping().get(1);
            tinyClass.getMapping().add(intermediaryToMCPMap.getOrDefault(classIntermediary, classIntermediary));
            for (TinyField tinyField : tinyClass.getFields()) {
                String fieldIntermediary = (String)tinyField.getMapping().get(1);
                docs = intermediaryToDocsMap.get(fieldIntermediary);
                tinyField.getMapping().add(intermediaryToMCPMap.getOrDefault(fieldIntermediary, fieldIntermediary));
                if (docs == null) continue;
                tinyField.getComments().clear();
                tinyField.getComments().addAll(Arrays.asList(docs));
            }
            for (TinyMethod tinyMethod : tinyClass.getMethods()) {
                Map<Integer, String> params;
                String methodIntermediary = (String)tinyMethod.getMapping().get(1);
                docs = intermediaryToDocsMap.get(methodIntermediary);
                tinyMethod.getMapping().add(intermediaryToMCPMap.getOrDefault(methodIntermediary, methodIntermediary));
                if (docs != null) {
                    tinyMethod.getComments().clear();
                    tinyMethod.getComments().addAll(Arrays.asList(docs));
                }
                if ((params = intermediaryToParamsMap.get(methodIntermediary)) == null) continue;
                for (Map.Entry<Integer, String> entry : params.entrySet()) {
                    int lvIndex = entry.getKey();
                    String paramName = entry.getValue();
                    ArrayList<String> mappings = new ArrayList<String>();
                    mappings.add("");
                    mappings.add("");
                    mappings.add(paramName);
                    tinyMethod.getParameters().add(new TinyMethodParameter(lvIndex, mappings, new ArrayList()));
                }
            }
        }
    }

    private void stripTinyWithParametersAndLocal(TinyFile tiny) {
        for (TinyClass tinyClass : tiny.getClassEntries()) {
            for (TinyMethod tinyMethod : tinyClass.getMethods()) {
                tinyMethod.getParameters().clear();
                tinyMethod.getLocalVariables().clear();
            }
        }
    }

    private Map<MemberToken, String> readSrg() throws IOException {
        HashMap<MemberToken, String> tokens = new HashMap<MemberToken, String>();
        try (BufferedReader reader = Files.newBufferedReader(this.srgTsrgPath, StandardCharsets.UTF_8);){
            String content = IOUtils.toString((Reader)reader);
            if (content.startsWith("tsrg2")) {
                this.readTsrg2(tokens, content);
            } else {
                MappingSet mappingSet = new TSrgReader((Reader)new StringReader(content)).read();
                for (TopLevelClassMapping classMapping : mappingSet.getTopLevelClassMappings()) {
                    this.appendClass((Map<MemberToken, String>)tokens, (ClassMapping<?, ?>)classMapping);
                }
            }
        }
        return tokens;
    }

    private void readTsrg2(Map<MemberToken, String> tokens, String content) throws IOException {
        MemoryMappingTree tree = new MemoryMappingTree();
        MappingReader.read((Reader)new StringReader(content), (MappingVisitor)tree);
        int obfIndex = tree.getNamespaceId("obf");
        int srgIndex = tree.getNamespaceId("srg");
        for (MappingTree.ClassMapping classDef : tree.getClasses()) {
            MemberToken ofClass = MemberToken.ofClass(classDef.getName(obfIndex));
            tokens.put(ofClass, classDef.getName(srgIndex));
            for (MappingTree.FieldMapping fieldDef : classDef.getFields()) {
                tokens.put(MemberToken.ofField(ofClass, fieldDef.getName(obfIndex)), fieldDef.getName(srgIndex));
            }
            for (MappingTree.MethodMapping methodDef : classDef.getMethods()) {
                tokens.put(MemberToken.ofMethod(ofClass, methodDef.getName(obfIndex), methodDef.getDesc(obfIndex)), methodDef.getName(srgIndex));
            }
        }
    }

    private void injectMcp(Path mcpJar, Map<String, String> intermediaryToSrgMap, Map<String, String[]> intermediaryToDocsMap, Map<String, Map<Integer, String>> intermediaryToParamsMap) throws IOException, CsvValidationException {
        block30: {
            Map<String, List<String>> srgToIntermediary = this.inverseMap(intermediaryToSrgMap);
            HashMap<String, List<String>> simpleSrgToIntermediary = new HashMap<String, List<String>>();
            Pattern methodPattern = Pattern.compile("(func_\\d*)_.*");
            for (Map.Entry<String, List<String>> entry : srgToIntermediary.entrySet()) {
                Matcher matcher = methodPattern.matcher(entry.getKey());
                if (!matcher.matches()) continue;
                simpleSrgToIntermediary.put(matcher.group(1), entry.getValue());
            }
            try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(mcpJar, false);){
                String[] docs;
                String[] line;
                Path fields = fs.getPath("fields.csv", new String[0]);
                Path methods = fs.getPath("methods.csv", new String[0]);
                Path params = fs.getPath("params.csv", new String[0]);
                Pattern paramsPattern = Pattern.compile("p_[^\\d]*(\\d+)_(\\d)+_?");
                try (CSVReader reader = new CSVReader((Reader)Files.newBufferedReader(fields, StandardCharsets.UTF_8));){
                    reader.readNext();
                    while ((line = reader.readNext()) != null) {
                        List<String> intermediaryField = srgToIntermediary.get(line[0]);
                        docs = line[3].split("\n");
                        if (intermediaryField == null) continue;
                        for (String s : intermediaryField) {
                            intermediaryToSrgMap.put(s, line[1]);
                            if (line[3].trim().isEmpty() || docs.length <= 0) continue;
                            intermediaryToDocsMap.put(s, docs);
                        }
                    }
                }
                reader = new CSVReader((Reader)Files.newBufferedReader(methods, StandardCharsets.UTF_8));
                try {
                    reader.readNext();
                    while ((line = reader.readNext()) != null) {
                        List<String> intermediaryMethod = srgToIntermediary.get(line[0]);
                        docs = line[3].split("\n");
                        if (intermediaryMethod == null) continue;
                        for (String s : intermediaryMethod) {
                            intermediaryToSrgMap.put(s, line[1]);
                            if (line[3].trim().isEmpty() || docs.length <= 0) continue;
                            intermediaryToDocsMap.put(s, docs);
                        }
                    }
                }
                finally {
                    reader.close();
                }
                if (!Files.exists(params, new LinkOption[0])) break block30;
                reader = new CSVReader((Reader)Files.newBufferedReader(params, StandardCharsets.UTF_8));
                try {
                    reader.readNext();
                    while ((line = reader.readNext()) != null) {
                        Matcher param = paramsPattern.matcher(line[0]);
                        if (!param.matches()) continue;
                        String named = line[1];
                        String srgMethodStartWith = "func_" + param.group(1);
                        int lvIndex = Integer.parseInt(param.group(2));
                        List intermediaryMethod = (List)simpleSrgToIntermediary.get(srgMethodStartWith);
                        if (intermediaryMethod == null) continue;
                        for (String s : intermediaryMethod) {
                            intermediaryToParamsMap.computeIfAbsent(s, s1 -> new HashMap()).put(lvIndex, named);
                        }
                    }
                }
                finally {
                    reader.close();
                }
            }
        }
    }

    private Map<String, List<String>> inverseMap(Map<String, String> intermediaryToMCPMap) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> token : intermediaryToMCPMap.entrySet()) {
            map.computeIfAbsent(token.getValue(), s -> new ArrayList()).add(token.getKey());
        }
        return map;
    }

    private void appendClass(Map<MemberToken, String> tokens, ClassMapping<?, ?> classMapping) {
        MemberToken ofClass = MemberToken.ofClass(classMapping.getFullObfuscatedName());
        tokens.put(ofClass, classMapping.getFullDeobfuscatedName());
        for (FieldMapping fieldMapping : classMapping.getFieldMappings()) {
            tokens.put(MemberToken.ofField(ofClass, fieldMapping.getObfuscatedName()), fieldMapping.getDeobfuscatedName());
        }
        for (MethodMapping methodMapping : classMapping.getMethodMappings()) {
            tokens.put(MemberToken.ofMethod(ofClass, methodMapping.getObfuscatedName(), methodMapping.getObfuscatedDescriptor()), methodMapping.getDeobfuscatedName());
        }
        for (InnerClassMapping mapping : classMapping.getInnerClassMappings()) {
            this.appendClass(tokens, (ClassMapping<?, ?>)mapping);
        }
    }

    private record MemberToken(TokenType type, @Nullable MemberToken owner, String name, @Nullable String descriptor) {
        static MemberToken ofClass(String name) {
            return new MemberToken(TokenType.CLASS, null, name, null);
        }

        static MemberToken ofField(MemberToken owner, String name) {
            return new MemberToken(TokenType.FIELD, owner, name, null);
        }

        static MemberToken ofMethod(MemberToken owner, String name, String descriptor) {
            return new MemberToken(TokenType.METHOD, owner, name, descriptor);
        }
    }

    private static enum TokenType {
        CLASS,
        METHOD,
        FIELD;

    }
}

