/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers.cache;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import net.fabricmc.loom.util.Checksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ClassEntry(String name, List<String> innerClasses, List<String> superClasses) {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassEntry.class);

    public void copyTo(Path sourceRoot, Path targetRoot) throws IOException {
        Path targetPath = targetRoot.resolve(this.name);
        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        Files.copy(sourceRoot.resolve(this.name), targetPath, new CopyOption[0]);
        for (String innerClass : this.innerClasses) {
            Files.copy(sourceRoot.resolve(innerClass), targetRoot.resolve(innerClass), new CopyOption[0]);
        }
    }

    public String hash(Path root) throws IOException {
        StringJoiner joiner = new StringJoiner(",");
        joiner.add(Checksum.sha256Hex(Files.readAllBytes(root.resolve(this.name))));
        for (String innerClass : this.innerClasses) {
            joiner.add(Checksum.sha256Hex(Files.readAllBytes(root.resolve(innerClass))));
        }
        return Checksum.sha256Hex(joiner.toString().getBytes());
    }

    public String hashSuperHierarchy(Map<String, String> hashes) throws IOException {
        String selfHash = Objects.requireNonNull(hashes.get(this.name), "Hash for own class not found");
        if (this.superClasses.isEmpty()) {
            return selfHash;
        }
        StringJoiner joiner = new StringJoiner(",");
        joiner.add(selfHash);
        for (String superClass : this.superClasses) {
            String superHash = hashes.get(superClass + ".class");
            if (superHash != null) {
                joiner.add(superHash);
                continue;
            }
            if (superClass.startsWith("java/")) continue;
            LOGGER.debug("Hash for super class {} of {} not found", (Object)superClass, (Object)this.name);
        }
        return Checksum.sha256Hex(joiner.toString().getBytes());
    }

    public String sourcesFileName() {
        return this.name.replace(".class", ".java");
    }
}

