/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import net.fabricmc.loom.api.manifest.VersionsManifestsAPI;

public class ManifestLocations
implements VersionsManifestsAPI,
Iterable<ManifestLocation> {
    private final Queue<ManifestLocation> locations = new PriorityQueue<ManifestLocation>();
    private final Set<String> manifestNames = new HashSet<String>();

    @Override
    public void add(String name, String url, int priority) {
        if (!this.manifestNames.add(name)) {
            throw new IllegalStateException("cannot add multiple versions manifests with the same name!");
        }
        this.locations.add(new ManifestLocation(name, url, priority));
    }

    @Override
    public Iterator<ManifestLocation> iterator() {
        return this.locations.iterator();
    }

    public class ManifestLocation
    implements Comparable<ManifestLocation> {
        private final String name;
        private final String url;
        private final int priority;

        private ManifestLocation(String name, String url, int priority) {
            this.name = name;
            this.url = url;
            this.priority = priority;
        }

        public String name() {
            return this.name;
        }

        public String url() {
            return this.url;
        }

        public Path cacheFile(Path dir) {
            return dir.resolve(this.name + "_versions_manifest.json");
        }

        @Override
        public int compareTo(ManifestLocation o) {
            return Integer.compare(this.priority, o.priority);
        }
    }
}

