/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.srg;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.MappingWriter;
import net.fabricmc.mappingio.adapter.ForwardingMappingVisitor;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.io.srg.tsrg.TSrgWriter;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.MethodMapping;

public class Tsrg2Utils {
    public static void writeTsrg(Consumer<MappingVisitor> visitorConsumer, String dstNamespace, boolean applyParameterMappings, Writer writer) throws IOException {
        MappingSet set;
        try (MappingsIO2LorenzWriter lorenzWriter = new MappingsIO2LorenzWriter(dstNamespace, applyParameterMappings);){
            visitorConsumer.accept((MappingVisitor)lorenzWriter);
            set = lorenzWriter.read();
        }
        try (TSrgWriter w = new TSrgWriter(writer);){
            w.write(set);
        }
    }

    public static class MappingsIO2LorenzWriter
    extends MappingsIO2Others {
        private final Object dstNamespaceUnresolved;
        private int dstNamespace;
        private boolean applyParameterMappings;

        public MappingsIO2LorenzWriter(int dstNamespace, boolean applyParameterMappings) {
            this.dstNamespaceUnresolved = dstNamespace;
            this.applyParameterMappings = applyParameterMappings;
        }

        public MappingsIO2LorenzWriter(String dstNamespace, boolean applyParameterMappings) {
            this.dstNamespaceUnresolved = dstNamespace;
            this.applyParameterMappings = applyParameterMappings;
        }

        public void visitNamespaces(String srcNamespace, List<String> dstNamespaces) throws IOException {
            super.visitNamespaces(srcNamespace, dstNamespaces);
            this.dstNamespace = this.dstNamespaceUnresolved instanceof Integer ? ((Integer)this.dstNamespaceUnresolved).intValue() : dstNamespaces.indexOf((String)this.dstNamespaceUnresolved);
        }

        public MappingSet read() throws IOException {
            return this.read(MappingSet.create());
        }

        public MappingSet read(MappingSet mappings) throws IOException {
            MappingTree tree = this.tree();
            for (MappingTree.ClassMapping aClass : tree.getClasses()) {
                ClassMapping lClass = (ClassMapping)mappings.getOrCreateClassMapping(aClass.getSrcName()).setDeobfuscatedName(aClass.getDstName(this.dstNamespace));
                for (MappingTree.FieldMapping aField : aClass.getFields()) {
                    String srcDesc = aField.getSrcDesc();
                    if (srcDesc == null || srcDesc.isEmpty()) {
                        lClass.getOrCreateFieldMapping(aField.getSrcName()).setDeobfuscatedName(aField.getDstName(this.dstNamespace));
                        continue;
                    }
                    lClass.getOrCreateFieldMapping(aField.getSrcName(), srcDesc).setDeobfuscatedName(aField.getDstName(this.dstNamespace));
                }
                for (MappingTree.MethodMapping aMethod : aClass.getMethods()) {
                    MethodMapping lMethod = (MethodMapping)lClass.getOrCreateMethodMapping(aMethod.getSrcName(), aMethod.getSrcDesc()).setDeobfuscatedName(aMethod.getDstName(this.dstNamespace));
                    if (!this.applyParameterMappings) continue;
                    for (MappingTree.MethodArgMapping aArg : aMethod.getArgs()) {
                        lMethod.getOrCreateParameterMapping(aArg.getLvIndex()).setDeobfuscatedName(aArg.getDstName(this.dstNamespace));
                    }
                }
            }
            return mappings;
        }
    }

    public static abstract class MappingsIO2Others
    extends ForwardingMappingVisitor
    implements MappingWriter {
        public MappingsIO2Others() {
            super((MappingVisitor)new MemoryMappingTree());
        }

        public MappingTree tree() {
            return (MappingTree)this.next;
        }

        public void close() throws IOException {
            MappingTree tree = this.tree();
            ArrayList<String> names = new ArrayList<String>();
            for (MappingTree.ClassMapping aClass : tree.getClasses()) {
                names.add(aClass.getSrcName());
            }
            for (String name : names) {
                tree.removeClass(name);
            }
        }
    }
}

