/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.srg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.loom.api.mappings.layered.MappingContext;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.forge.SrgProvider;
import net.fabricmc.loom.util.MappingException;
import net.fabricmc.loom.util.function.CollectionUtil;
import net.fabricmc.mappingio.FlatMappingVisitor;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.ForwardingMappingVisitor;
import net.fabricmc.mappingio.adapter.MappingNsRenamer;
import net.fabricmc.mappingio.adapter.MappingSourceNsSwitch;
import net.fabricmc.mappingio.adapter.RegularAsFlatMappingVisitor;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.format.srg.TsrgFileReader;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MappingTreeView;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.jetbrains.annotations.Nullable;

public final class ForgeMappingsMerger {
    private static final List<String> INPUT_NAMESPACES = List.of("official", "intermediary", "named");
    private static final List<String> INPUT_NAMESPACES_WITH_MOJANG = List.of("official", "mojang", "intermediary", "named");
    private final MemoryMappingTree newNs;
    private final MemoryMappingTree src;
    private final MemoryMappingTree output;
    private final FlatMappingVisitor flatOutput;
    private final boolean lenient;
    @Nullable
    private final MemoryMappingTree extra;
    private final ListMultimap<MethodKey, MethodData> methodsByNewNs;

    private ForgeMappingsMerger(MemoryMappingTree newNs, MemoryMappingTree src, @Nullable ExtraMappings extraMappings, boolean lenient) throws IOException {
        this.newNs = newNs;
        Preconditions.checkArgument((this.newNs.getDstNamespaces().size() == 1 ? 1 : 0) != 0, (Object)"New namespace must have exactly one destination namespace");
        this.src = src;
        this.output = new MemoryMappingTree();
        this.flatOutput = new RegularAsFlatMappingVisitor((MappingVisitor)this.output);
        this.lenient = lenient;
        this.methodsByNewNs = ArrayListMultimap.create();
        if (extraMappings != null) {
            this.extra = new MemoryMappingTree();
            MappingSourceNsSwitch visitor = new MappingSourceNsSwitch((MappingVisitor)this.extra, MappingsNamespace.OFFICIAL.toString());
            if (!extraMappings.hasCorrectNamespaces()) {
                Map<String, String> namespaces = Map.of(extraMappings.obfuscatedNamespace(), MappingsNamespace.OFFICIAL.toString(), extraMappings.deobfuscatedNamespace(), MappingsNamespace.NAMED.toString());
                visitor = new MappingNsRenamer((MappingVisitor)visitor, namespaces);
            }
            MappingReader.read((Path)extraMappings.path(), (MappingFormat)extraMappings.format(), (MappingVisitor)visitor);
        } else {
            this.extra = null;
        }
        ArrayList<String> newDstNamespaces = new ArrayList<String>();
        newDstNamespaces.add((String)this.newNs.getDstNamespaces().get(0));
        newDstNamespaces.addAll(this.src.getDstNamespaces());
        this.output.visitNamespaces(this.src.getSrcNamespace(), newDstNamespaces);
    }

    private static MemoryMappingTree readInput(Path tiny) throws IOException {
        MemoryMappingTree src = new MemoryMappingTree();
        MappingReader.read((Path)tiny, (MappingVisitor)src);
        ArrayList<String> inputNamespaces = new ArrayList<String>(src.getDstNamespaces());
        inputNamespaces.add(0, src.getSrcNamespace());
        if (!inputNamespaces.equals(INPUT_NAMESPACES) && !inputNamespaces.equals(INPUT_NAMESPACES_WITH_MOJANG)) {
            throw new MappingException("Mapping file " + String.valueOf(tiny) + " does not have 'official(, mojang), intermediary, named' as its namespaces! Found: " + String.valueOf(inputNamespaces));
        }
        return src;
    }

    private String[] createDstNameArray(MappingTreeView.ElementMappingView newNs) {
        String[] dstNames = new String[this.output.getDstNamespaces().size()];
        dstNames[0] = newNs.getDstName(0);
        return dstNames;
    }

    private void copyDstNames(String[] dstNames, MappingTreeView.ElementMappingView from) {
        for (int i = 1; i < dstNames.length; ++i) {
            dstNames[i] = from.getDstName(i - 1);
        }
    }

    private void fillMappings(String[] names, MappingTreeView.ElementMappingView newNs) {
        for (int i = 1; i < names.length; ++i) {
            names[i] = newNs.getSrcName();
        }
    }

    public MemoryMappingTree merge() throws IOException {
        for (MappingTree.ClassMapping newNsClass : this.newNs.getClasses()) {
            String[] dstNames = this.createDstNameArray((MappingTreeView.ElementMappingView)newNsClass);
            MappingTree.ClassMapping tinyClass = this.src.getClass(newNsClass.getSrcName());
            String comment = null;
            if (tinyClass != null) {
                this.copyDstNames(dstNames, (MappingTreeView.ElementMappingView)tinyClass);
                comment = tinyClass.getComment();
            } else if (this.lenient) {
                this.fillMappings(dstNames, (MappingTreeView.ElementMappingView)newNsClass);
            } else {
                throw new MappingException("Could not find class " + newNsClass.getSrcName() + "|" + newNsClass.getDstName(0));
            }
            this.flatOutput.visitClass(newNsClass.getSrcName(), dstNames);
            if (comment != null) {
                this.flatOutput.visitClassComment(newNsClass.getSrcName(), comment);
            }
            for (MappingTree.FieldMapping field : newNsClass.getFields()) {
                this.mergeField(newNsClass, field, tinyClass);
            }
            for (MappingTree.MethodMapping method : newNsClass.getMethods()) {
                this.mergeMethod(newNsClass, method, tinyClass);
            }
        }
        this.resolveConflicts();
        return this.output;
    }

    private void mergeField(MappingTree.ClassMapping newNsClass, MappingTree.FieldMapping newNsField, @Nullable MappingTree.ClassMapping tinyClass) throws IOException {
        String[] dstNames = this.createDstNameArray((MappingTreeView.ElementMappingView)newNsField);
        MappingTree.FieldMapping tinyField = null;
        String srcDesc = newNsField.getSrcDesc();
        String comment = null;
        if (tinyClass != null) {
            tinyField = srcDesc != null ? tinyClass.getField(newNsField.getSrcName(), newNsField.getSrcDesc()) : (MappingTree.FieldMapping)CollectionUtil.find(tinyClass.getFields(), field -> field.getSrcName().equals(newNsField.getSrcName())).orElse(null);
        } else if (!this.lenient) {
            throw new MappingException("Could not find field " + newNsClass.getDstName(0) + "." + newNsField.getDstName(0) + " " + newNsField.getDstDesc(0));
        }
        if (tinyField != null) {
            this.copyDstNames(dstNames, (MappingTreeView.ElementMappingView)tinyField);
            srcDesc = tinyField.getSrcDesc();
            comment = tinyField.getComment();
        } else {
            this.fillMappings(dstNames, (MappingTreeView.ElementMappingView)newNsField);
        }
        if (srcDesc != null) {
            this.flatOutput.visitField(newNsClass.getSrcName(), newNsField.getSrcName(), srcDesc, dstNames);
            if (comment != null) {
                this.flatOutput.visitFieldComment(newNsClass.getSrcName(), newNsField.getSrcName(), srcDesc, comment);
            }
        } else if (!this.lenient) {
            throw new MappingException("Could not find descriptor for field " + newNsClass.getDstName(0) + "." + newNsField.getDstName(0));
        }
    }

    private void mergeMethod(MappingTree.ClassMapping newNsClass, MappingTree.MethodMapping newNsMethod, @Nullable MappingTree.ClassMapping tinyClass) throws IOException {
        String namedName;
        String intermediaryName;
        String[] dstNames = this.createDstNameArray((MappingTreeView.ElementMappingView)newNsMethod);
        MappingTree.MethodMapping tinyMethod = null;
        String comment = null;
        if (tinyClass != null) {
            tinyMethod = tinyClass.getMethod(newNsMethod.getSrcName(), newNsMethod.getSrcDesc());
        } else if (!this.lenient) {
            throw new MappingException("Could not find method " + newNsClass.getDstName(0) + "." + newNsMethod.getDstName(0) + " " + newNsMethod.getDstDesc(0));
        }
        if (tinyMethod != null) {
            this.copyDstNames(dstNames, (MappingTreeView.ElementMappingView)tinyMethod);
            intermediaryName = tinyMethod.getName("intermediary");
            namedName = tinyMethod.getName("named");
            comment = tinyMethod.getComment();
        } else {
            MappingTree.MethodMapping extraMethod;
            if (newNsMethod.getSrcName().equals(newNsMethod.getDstName(0))) {
                return;
            }
            MappingTree.MethodMapping fillMethod = null;
            if (this.extra != null && (extraMethod = this.extra.getMethod(newNsClass.getSrcName(), newNsMethod.getSrcName(), newNsMethod.getSrcDesc())) != null && extraMethod.getSrcName().equals(extraMethod.getDstName(0))) {
                fillMethod = extraMethod;
            }
            if (fillMethod != null) {
                this.fillMappings(dstNames, (MappingTreeView.ElementMappingView)fillMethod);
                intermediaryName = namedName = fillMethod.getSrcName();
            } else {
                return;
            }
        }
        if (!newNsMethod.getSrcName().equals(dstNames[0])) {
            this.methodsByNewNs.put((Object)new MethodKey(dstNames[0], newNsMethod.getSrcDesc()), (Object)new MethodData(newNsClass.getSrcName(), newNsMethod.getSrcName(), newNsMethod.getSrcDesc(), tinyMethod != null, intermediaryName, namedName));
        }
        this.flatOutput.visitMethod(newNsClass.getSrcName(), newNsMethod.getSrcName(), newNsMethod.getSrcDesc(), dstNames);
        if (comment != null) {
            this.flatOutput.visitMethodComment(newNsClass.getSrcName(), newNsMethod.getSrcName(), newNsMethod.getSrcDesc(), comment);
        }
        if (tinyMethod != null) {
            for (MappingTree.MethodArgMapping arg : tinyMethod.getArgs()) {
                String[] argDstNames = new String[this.output.getDstNamespaces().size()];
                this.copyDstNames(argDstNames, (MappingTreeView.ElementMappingView)arg);
                this.flatOutput.visitMethodArg(newNsClass.getSrcName(), newNsMethod.getSrcName(), newNsMethod.getSrcDesc(), arg.getArgPosition(), arg.getLvIndex(), arg.getSrcName(), argDstNames);
                if (arg.getComment() == null) continue;
                this.flatOutput.visitMethodArgComment(newNsClass.getSrcName(), newNsMethod.getSrcName(), newNsMethod.getSrcDesc(), arg.getArgPosition(), arg.getLvIndex(), arg.getSrcName(), arg.getComment());
            }
        }
    }

    private void resolveConflicts() {
        ArrayList conflicts = new ArrayList();
        for (MethodKey methodKey : this.methodsByNewNs.keySet()) {
            MethodData preferred;
            List methods = this.methodsByNewNs.get((Object)methodKey);
            if (methods.size() == 1) continue;
            HashSet<String> foundNamedNames = new HashSet<String>();
            for (MethodData method : methods) {
                foundNamedNames.add(method.namedName());
            }
            if (foundNamedNames.size() == 1 || (preferred = this.findPreferredMethod(methods, conflicts::add)) == null) continue;
            for (MethodData method : methods) {
                if (method == preferred) continue;
                MappingTree.ClassMapping clazz = this.output.getClass(method.obfOwner());
                clazz.getMethods().removeIf(m -> m.getSrcName().equals(method.obfName()) && m.getSrcDesc().equals(method.obfDesc()));
            }
        }
        if (!conflicts.isEmpty()) {
            throw new MappingException("Unfixable conflicts:\n" + String.join((CharSequence)"\n", conflicts));
        }
    }

    @Nullable
    private MethodData findPreferredMethod(List<MethodData> methods, Consumer<String> conflictReporter) {
        List<MethodData> hasTiny = CollectionUtil.filter(methods, MethodData::hasTiny);
        if (hasTiny.size() > 1) {
            HashSet<String> intermediaryNames = new HashSet<String>();
            for (MethodData method : methods) {
                intermediaryNames.add(method.intermediaryName());
            }
            if (intermediaryNames.size() == 1) {
                StringBuilder message = new StringBuilder();
                message.append("- multiple preferred methods for ").append(this.newNs).append(':');
                for (MethodData preferred : hasTiny) {
                    message.append("\n\t> ").append(preferred);
                }
                conflictReporter.accept(message.toString());
            }
            return null;
        }
        if (hasTiny.isEmpty()) {
            conflictReporter.accept("- no preferred methods found for " + String.valueOf(this.newNs) + ", available: " + String.valueOf(methods));
            return null;
        }
        return hasTiny.get(0);
    }

    public static MemoryMappingTree mergeSrg(Path srg, Path tiny, @Nullable ExtraMappings extraMappings, boolean lenient) throws IOException, MappingException {
        return new ForgeMappingsMerger(ForgeMappingsMerger.readSrg(srg), ForgeMappingsMerger.readInput(tiny), extraMappings, lenient).merge();
    }

    public static MemoryMappingTree mergeMojang(MappingContext context, Path tiny, @Nullable ExtraMappings extraMappings, boolean lenient) throws IOException, MappingException {
        MemoryMappingTree mojang = new MemoryMappingTree();
        SrgProvider.visitMojangMappings((MappingVisitor)new MappingNsRenamer((MappingVisitor)mojang, Map.of(MappingsNamespace.NAMED.toString(), MappingsNamespace.MOJANG.toString())), context);
        return new ForgeMappingsMerger(mojang, ForgeMappingsMerger.readInput(tiny), extraMappings, lenient).merge();
    }

    private static MemoryMappingTree readSrg(Path srg) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(srg);){
            MemoryMappingTree output = new MemoryMappingTree();
            TsrgFileReader.read((Reader)reader, (MappingVisitor)new ForwardingMappingVisitor((MappingVisitor)output){

                public void visitNamespaces(String srcNamespace, List<String> dstNamespaces) throws IOException {
                    ArrayList<String> newDstNamespaces = new ArrayList<String>(dstNamespaces);
                    newDstNamespaces.set(0, MappingsNamespace.SRG.toString());
                    super.visitNamespaces(MappingsNamespace.OFFICIAL.toString(), newDstNamespaces);
                }
            });
            MemoryMappingTree memoryMappingTree = output;
            return memoryMappingTree;
        }
    }

    public record ExtraMappings(Path path, MappingFormat format, String obfuscatedNamespace, String deobfuscatedNamespace) {
        boolean hasCorrectNamespaces() {
            return this.obfuscatedNamespace.equals(MappingsNamespace.OFFICIAL.toString()) && this.deobfuscatedNamespace.equals(MappingsNamespace.NAMED.toString());
        }

        public static ExtraMappings ofMojmapTsrg(Path path) {
            return new ExtraMappings(path, MappingFormat.TSRG_2_FILE, MappingsNamespace.OFFICIAL.toString(), MappingsNamespace.NAMED.toString());
        }
    }

    private record MethodKey(String name, String desc) {
        @Override
        public String toString() {
            return this.name + this.desc;
        }
    }

    private record MethodData(String obfOwner, String obfName, String obfDesc, boolean hasTiny, String intermediaryName, String namedName) {
        @Override
        public String toString() {
            return "%s.%s%s => %s/%s (%s)".formatted(this.obfOwner, this.obfName, this.obfDesc, this.intermediaryName, this.namedName, this.hasTiny ? "tiny" : "filled");
        }
    }
}

