/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.loom.util.service.BuildSharedServiceManager;
import net.fabricmc.loom.util.service.SharedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SharedServiceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildSharedServiceManager.class);
    private final Map<String, SharedService> sharedServiceMap = new HashMap<String, SharedService>();
    private boolean shutdown = false;

    SharedServiceManager() {
        LOGGER.info("Creating new SharedServiceManager({})", (Object)this.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends SharedService> S getOrCreateService(String id, Supplier<S> function) {
        Map<String, SharedService> map = this.sharedServiceMap;
        synchronized (map) {
            if (this.shutdown) {
                throw new UnsupportedOperationException("Cannot get or create service has the manager has been shutdown.");
            }
            SharedService sharedService = this.sharedServiceMap.get(id);
            if (sharedService == null) {
                LOGGER.debug("Creating service for {}", (Object)id);
                sharedService = (SharedService)function.get();
                this.sharedServiceMap.put(id, sharedService);
            }
            return (S)sharedService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFinish() {
        Map<String, SharedService> map = this.sharedServiceMap;
        synchronized (map) {
            this.shutdown = true;
        }
        LOGGER.info("Closing SharedServiceManager({})", (Object)this.hashCode());
        ArrayList<IOException> exceptionList = new ArrayList<IOException>();
        for (SharedService sharedService : this.sharedServiceMap.values()) {
            try {
                sharedService.close();
            }
            catch (IOException e) {
                exceptionList.add(e);
            }
        }
        this.sharedServiceMap.clear();
        System.gc();
        if (!exceptionList.isEmpty()) {
            RuntimeException exception = new RuntimeException("Failed to close all shared services");
            exceptionList.forEach(exception::addSuppressed);
            throw exception;
        }
    }
}

