/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.service;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.loom.util.service.SharedServiceManager;
import org.gradle.api.Task;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BuildSharedServiceManager
implements BuildService<BuildServiceParameters.None> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildSharedServiceManager.class);
    private static final String NAME = "loom:sharedServiceManager";
    private SharedServiceManager sharedServiceManager = new BuildSharedServiceManagerImpl();
    private final AtomicInteger refCount = new AtomicInteger(0);

    public static Provider<BuildSharedServiceManager> createForTask(Task task, BuildEventsListenerRegistry buildEventsListenerRegistry) {
        Provider provider = task.getProject().getGradle().getSharedServices().registerIfAbsent(NAME, BuildSharedServiceManager.class, spec -> {});
        task.usesService(provider);
        BuildSharedServiceManager serviceManager = (BuildSharedServiceManager)provider.get();
        buildEventsListenerRegistry.onTaskCompletion(BuildSharedServiceManager.registerTaskCompletion(task, serviceManager::onFinish));
        int count = serviceManager.refCount.incrementAndGet();
        LOGGER.debug("Creating shared service manager provider for task: {} count: {}", (Object)task.getName(), (Object)count);
        return provider;
    }

    public BuildSharedServiceManager() {
        LOGGER.debug("New BuildSharedServiceManager instance");
    }

    public SharedServiceManager get() {
        LOGGER.debug("Shared build service get");
        return Objects.requireNonNull(this.sharedServiceManager);
    }

    private void onFinish() {
        int count = this.refCount.decrementAndGet();
        LOGGER.debug("Build service finish. count: {}", (Object)count);
        if (count == 0) {
            this.sharedServiceManager.onFinish();
            this.sharedServiceManager = null;
        } else if (count < 0) {
            throw new IllegalStateException();
        }
    }

    private static Provider<OperationCompletionListener> registerTaskCompletion(Task task, Runnable runnable) {
        return task.getProject().provider(() -> event -> {
            TaskOperationDescriptor taskDescriptor;
            OperationDescriptor patt0$temp = event.getDescriptor();
            if (patt0$temp instanceof TaskOperationDescriptor && (taskDescriptor = (TaskOperationDescriptor)patt0$temp).getTaskPath().equals(task.getPath())) {
                runnable.run();
            }
        });
    }

    private static final class BuildSharedServiceManagerImpl
    extends SharedServiceManager {
        private BuildSharedServiceManagerImpl() {
        }
    }
}

