/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.gradle;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ProjectDependency;

@Deprecated
public class SelfResolvingDependencyUtils {
    public static final boolean DISABLE_SRD_SUPPORT = System.getProperty("fabric.loom.disable.srd") != null;
    private static final String SELF_RESOLVING_DEPENDENCY_CLASS_NAME = "org.gradle.api.artifacts.SelfResolvingDependency";
    @Nullable
    private static final Class<?> SELF_RESOLVING_DEPENDENCY_CLASS = SelfResolvingDependencyUtils.getSelfResolvingDependencyOrNull();
    @Nullable
    private static final Method RESOLVE_METHOD = SelfResolvingDependencyUtils.getResolveMethod(SELF_RESOLVING_DEPENDENCY_CLASS);

    public static boolean isExplicitSRD(Dependency dependency) {
        if (dependency instanceof FileCollectionDependency) {
            return false;
        }
        if (dependency instanceof ProjectDependency) {
            return false;
        }
        return SelfResolvingDependencyUtils.isSRD(dependency);
    }

    private static boolean isSRD(Dependency dependency) {
        if (SELF_RESOLVING_DEPENDENCY_CLASS == null) {
            return false;
        }
        return dependency.getClass().isAssignableFrom(SELF_RESOLVING_DEPENDENCY_CLASS);
    }

    public static Set<File> resolve(Dependency dependency) {
        if (!SelfResolvingDependencyUtils.isSRD(dependency)) {
            throw new IllegalStateException("dependency is not a SelfResolvingDependency");
        }
        try {
            return (Set)RESOLVE_METHOD.invoke((Object)dependency, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to resolve SelfResolvingDependency", e);
        }
    }

    @Nullable
    private static Class<?> getSelfResolvingDependencyOrNull() {
        if (DISABLE_SRD_SUPPORT) {
            return null;
        }
        try {
            return Class.forName(SELF_RESOLVING_DEPENDENCY_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Nullable
    private static Method getResolveMethod(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            Method method = clazz.getDeclaredMethod("resolve", new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Failed to get SelfResolvingDependency.resolve() method", e);
        }
    }
}

