/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import com.google.common.collect.ImmutableMap;
import dev.architectury.loom.util.MappingOption;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.util.MappingException;
import net.fabricmc.loom.util.RecordComponentFixVisitor;
import net.fabricmc.loom.util.service.SharedServiceManager;
import net.fabricmc.loom.util.srg.InnerClassRemapper;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.gradle.api.Project;

public final class TinyRemapperHelper {
    public static final Map<String, String> JSR_TO_JETBRAINS = new ImmutableMap.Builder().put((Object)"javax/annotation/Nullable", (Object)"org/jetbrains/annotations/Nullable").put((Object)"javax/annotation/Nonnull", (Object)"org/jetbrains/annotations/NotNull").put((Object)"javax/annotation/concurrent/Immutable", (Object)"org/jetbrains/annotations/Unmodifiable").build();
    private static final Pattern MC_LV_PATTERN = Pattern.compile("\\$\\$\\d+");

    private TinyRemapperHelper() {
    }

    public static TinyRemapper getTinyRemapper(Project project, SharedServiceManager serviceManager, String fromM, String toM) throws IOException {
        return TinyRemapperHelper.getTinyRemapper(project, serviceManager, fromM, toM, false, builder -> {}, Set.of());
    }

    public static TinyRemapper getTinyRemapper(Project project, SharedServiceManager serviceManager, String fromM, String toM, boolean fixRecords, Consumer<TinyRemapper.Builder> builderConsumer, Set<String> fromClassNames) throws IOException {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        MappingOption mappingOption = MappingOption.forPlatform(extension);
        MemoryMappingTree mappingTree = extension.getMappingConfiguration().getMappingsService(serviceManager, mappingOption).getMappingTree();
        if (fixRecords && !mappingTree.getSrcNamespace().equals(fromM)) {
            throw new IllegalStateException("Mappings src namespace must match remap src namespace, expected " + fromM + " but got " + mappingTree.getSrcNamespace());
        }
        int intermediaryNsId = mappingTree.getNamespaceId(MappingsNamespace.INTERMEDIARY.toString());
        TinyRemapper.Builder builder = TinyRemapper.newRemapper().ignoreConflicts(extension.isForgeLike()).threads(Runtime.getRuntime().availableProcessors()).withMappings(TinyRemapperHelper.create((MappingTree)mappingTree, fromM, toM, true)).renameInvalidLocals(true).rebuildSourceFilenames(true).invalidLvNamePattern(MC_LV_PATTERN).inferNameFromSameLvIndex(true).withKnownIndyBsm((Set)extension.getKnownIndyBsms().get()).extraPreApplyVisitor((cls, next) -> {
            if (fixRecords && !cls.isRecord() && "java/lang/Record".equals(cls.getSuperName())) {
                return new RecordComponentFixVisitor(next, mappingTree, intermediaryNsId);
            }
            return next;
        });
        if (extension.isForgeLike()) {
            if (!fromClassNames.isEmpty()) {
                builder.withMappings(InnerClassRemapper.of(fromClassNames, (MappingTree)mappingTree, fromM, toM));
            }
        } else {
            builder.withMappings(out -> JSR_TO_JETBRAINS.forEach((arg_0, arg_1) -> ((IMappingProvider.MappingAcceptor)out).acceptClass(arg_0, arg_1)));
        }
        builderConsumer.accept(builder);
        return builder.build();
    }

    private static IMappingProvider.Member memberOf(String className, String memberName, String descriptor) {
        return new IMappingProvider.Member(className, memberName, descriptor);
    }

    public static IMappingProvider create(Path mappings, String from, String to, boolean remapLocalVariables) throws IOException {
        MemoryMappingTree mappingTree = new MemoryMappingTree();
        MappingReader.read((Path)mappings, (MappingVisitor)mappingTree);
        return TinyRemapperHelper.create((MappingTree)mappingTree, from, to, remapLocalVariables);
    }

    public static IMappingProvider create(MappingTree mappings, String from, String to, boolean remapLocalVariables) {
        return acceptor -> {
            int fromId = mappings.getNamespaceId(from);
            int toId = mappings.getNamespaceId(to);
            if (toId == -2) {
                throw new MappingException("Trying to remap from '%s' (id: %d) to unknown namespace '%s'. Available namespaces: [%s -> %s]".formatted(from, fromId, to, mappings.getSrcNamespace(), String.join((CharSequence)", ", mappings.getDstNamespaces())));
            }
            for (MappingTree.ClassMapping classDef : mappings.getClasses()) {
                String className = classDef.getName(fromId);
                String dstName = classDef.getName(toId);
                if (dstName == null) {
                    dstName = className;
                }
                acceptor.acceptClass(className, dstName);
                for (MappingTree.FieldMapping field : classDef.getFields()) {
                    acceptor.acceptField(TinyRemapperHelper.memberOf(className, field.getName(fromId), field.getDesc(fromId)), field.getName(toId));
                }
                for (MappingTree.MethodMapping method : classDef.getMethods()) {
                    IMappingProvider.Member methodIdentifier = TinyRemapperHelper.memberOf(className, method.getName(fromId), method.getDesc(fromId));
                    acceptor.acceptMethod(methodIdentifier, method.getName(toId));
                    if (!remapLocalVariables) continue;
                    for (MappingTree.MethodArgMapping parameter : method.getArgs()) {
                        String name = parameter.getName(toId);
                        if (name == null) continue;
                        acceptor.acceptMethodArg(methodIdentifier, parameter.getLvIndex(), name);
                    }
                    for (MappingTree.MethodVarMapping localVariable : method.getVars()) {
                        acceptor.acceptMethodVar(methodIdentifier, localVariable.getLvIndex(), localVariable.getStartOpIdx(), localVariable.getLvtRowIndex(), localVariable.getName(toId));
                    }
                }
            }
        };
    }
}

