/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import net.fabricmc.loom.nativeplatform.LoomNativePlatform;
import net.fabricmc.loom.nativeplatform.LoomNativePlatformException;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ProcessUtil(LogLevel logLevel) {
    private static final String EXPLORER_COMMAND = "C:\\Windows\\explorer.exe";
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessUtil.class);

    public static ProcessUtil create(Project project) {
        return new ProcessUtil(project.getGradle().getStartParameter().getLogLevel());
    }

    public String printWithParents(ProcessHandle handle) {
        String result = this.printWithParents(handle, 0).trim();
        if (this.logLevel != LogLevel.INFO && this.logLevel != LogLevel.DEBUG) {
            return "Run with --info or --debug to show arguments, may reveal sensitive info\n" + result;
        }
        return result;
    }

    private String printWithParents(ProcessHandle handle, int depth) {
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        this.getWindowTitles(handle).ifPresent(titles -> lines.add((CallSite)((Object)("title: " + titles))));
        lines.add((CallSite)((Object)("pid: " + handle.pid())));
        handle.info().command().ifPresent(command -> lines.add((CallSite)((Object)("command: " + command))));
        this.getProcessArguments(handle).ifPresent(arguments -> lines.add((CallSite)((Object)("arguments: " + arguments))));
        handle.info().startInstant().ifPresent(instant -> lines.add((CallSite)((Object)("started at: " + String.valueOf(instant)))));
        handle.info().user().ifPresent(user -> lines.add((CallSite)((Object)("user: " + user))));
        handle.parent().ifPresent(parent -> lines.add((CallSite)((Object)("parent:\n" + this.printWithParents((ProcessHandle)parent, depth + 1)))));
        StringBuilder sj = new StringBuilder();
        for (String string : lines) {
            sj.append("\t".repeat(depth)).append("- ").append(string).append('\n');
        }
        return sj.toString();
    }

    private Optional<String> getProcessArguments(ProcessHandle handle) {
        if (this.logLevel != LogLevel.INFO && this.logLevel != LogLevel.DEBUG) {
            return Optional.empty();
        }
        return handle.info().arguments().map(arr -> {
            String join = String.join((CharSequence)" ", arr);
            if (join.isBlank()) {
                return "";
            }
            return " " + join;
        });
    }

    private Optional<String> getWindowTitles(ProcessHandle processHandle) {
        List titles;
        if (processHandle.info().command().orElse("").equals(EXPLORER_COMMAND)) {
            return Optional.empty();
        }
        try {
            titles = LoomNativePlatform.getWindowTitlesForPid((long)processHandle.pid());
        }
        catch (LoomNativePlatformException e) {
            LOGGER.error("{}, Failed to query window title for pid {}", (Object)e.getMessage(), (Object)processHandle.pid());
            return Optional.empty();
        }
        if (titles.isEmpty()) {
            return Optional.empty();
        }
        StringJoiner joiner = new StringJoiner(", ");
        for (String title : titles) {
            joiner.add("'" + title + "'");
        }
        return Optional.of(joiner.toString());
    }
}

