/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.File;
import java.nio.file.Path;
import javax.inject.Inject;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.task.RemapJarTask;
import net.fabricmc.loom.task.service.TinyRemapperService;
import net.fabricmc.loom.util.service.UnsafeWorkQueueHelper;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

public abstract class PrepareJarRemapTask
extends AbstractLoomTask {
    private final RemapJarTask remapJarTask;

    @InputFile
    public abstract RegularFileProperty getInputFile();

    @Inject
    public PrepareJarRemapTask(RemapJarTask remapJarTask) {
        this.remapJarTask = remapJarTask;
        this.getInputFile().set((Provider)remapJarTask.getInputFile());
        this.getOutputs().upToDateWhen(o -> false);
        this.getProject().getGradle().allprojects(project -> project.getTasks().withType(PrepareJarRemapTask.class, otherTask -> {
            if (otherTask == this) {
                return;
            }
            this.dependsOn(new Object[]{otherTask.getInputs()});
            this.mustRunAfter(new Object[]{otherTask.getInputs()});
        }));
    }

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @TaskAction
    public void run() {
        WorkQueue workQueue = this.getWorkerExecutor().noIsolation();
        workQueue.submit(ReadInputsAction.class, params -> {
            params.getTinyRemapperBuildServiceUuid().set((Object)UnsafeWorkQueueHelper.create(this.remapJarTask.getTinyRemapperService()));
            params.getInputFile().set((Provider)this.getInputFile());
        });
    }

    static void prepare(TinyRemapperService tinyRemapperService, Path inputFile) {
        tinyRemapperService.getTinyRemapperForInputs().readInputsAsync(tinyRemapperService.getOrCreateTag(inputFile), new Path[]{inputFile});
    }

    public static abstract class ReadInputsAction
    implements WorkAction<ReadInputsParams> {
        private final TinyRemapperService tinyRemapperService = UnsafeWorkQueueHelper.get(((ReadInputsParams)this.getParameters()).getTinyRemapperBuildServiceUuid(), TinyRemapperService.class);

        public void execute() {
            Path inputFile = ((File)((ReadInputsParams)this.getParameters()).getInputFile().getAsFile().get()).toPath();
            PrepareJarRemapTask.prepare(this.tinyRemapperService, inputFile);
        }
    }

    public static interface ReadInputsParams
    extends WorkParameters {
        public Property<String> getTinyRemapperBuildServiceUuid();

        public RegularFileProperty getInputFile();
    }
}

