/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.decompilers.DecompilationMetadata;
import net.fabricmc.loom.api.decompilers.DecompilerOptions;
import net.fabricmc.loom.api.decompilers.LoomDecompiler;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.ConfigContextImpl;
import net.fabricmc.loom.configuration.processors.MappingProcessorContextImpl;
import net.fabricmc.loom.configuration.processors.MinecraftJarProcessorManager;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJar;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.AbstractMappedMinecraftProvider;
import net.fabricmc.loom.configuration.sources.ForgeSourcesRemapper;
import net.fabricmc.loom.decompilers.ClassLineNumbers;
import net.fabricmc.loom.decompilers.LineNumberRemapper;
import net.fabricmc.loom.decompilers.cache.CachedData;
import net.fabricmc.loom.decompilers.cache.CachedFileStoreImpl;
import net.fabricmc.loom.decompilers.cache.CachedJarProcessor;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.util.Checksum;
import net.fabricmc.loom.util.ExceptionUtil;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.IOStringConsumer;
import net.fabricmc.loom.util.Platform;
import net.fabricmc.loom.util.gradle.SyncTaskBuildService;
import net.fabricmc.loom.util.gradle.ThreadedProgressLoggerConsumer;
import net.fabricmc.loom.util.gradle.ThreadedSimpleProgressLogger;
import net.fabricmc.loom.util.gradle.WorkerDaemonClientsManagerHelper;
import net.fabricmc.loom.util.ipc.IPCClient;
import net.fabricmc.loom.util.ipc.IPCServer;
import net.fabricmc.loom.util.service.ScopedSharedServiceManager;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.MappingSourceNsSwitch;
import net.fabricmc.mappingio.format.tiny.Tiny2FileWriter;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.gradle.workers.internal.WorkerDaemonClientsManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisableCachingByDefault
public abstract class GenerateSourcesTask
extends AbstractLoomTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerateSourcesTask.class);
    private static final String CACHE_VERSION = "v1";
    private final DecompilerOptions decompilerOptions;

    @Input
    public abstract Property<String> getInputJarName();

    @InputFiles
    public abstract ConfigurableFileCollection getClasspath();

    @OutputFile
    public abstract RegularFileProperty getOutputJar();

    @InputFile
    @Optional
    public abstract RegularFileProperty getUnpickDefinitions();

    @InputFiles
    @Optional
    public abstract ConfigurableFileCollection getUnpickConstantJar();

    @InputFiles
    @Optional
    public abstract ConfigurableFileCollection getUnpickClasspath();

    @InputFiles
    @Optional
    @ApiStatus.Internal
    public abstract ConfigurableFileCollection getUnpickRuntimeClasspath();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getUnpickOutputJar();

    @Input
    @Option(option="use-cache", description="Use the decompile cache")
    @ApiStatus.Experimental
    public abstract Property<Boolean> getUseCache();

    @Input
    @Option(option="reset-cache", description="When set the cache will be reset")
    @ApiStatus.Experimental
    public abstract Property<Boolean> getResetCache();

    @Internal
    @ApiStatus.Internal
    protected abstract RegularFileProperty getDecompileCacheFile();

    @Inject
    public abstract WorkerExecutor getWorkerExecutor();

    @Inject
    public abstract ExecOperations getExecOperations();

    @Inject
    public abstract WorkerDaemonClientsManager getWorkerDaemonClientsManager();

    @ServiceReference(value="loomSyncTask")
    abstract Property<SyncTaskBuildService> getSyncTask();

    @Inject
    public GenerateSourcesTask(DecompilerOptions decompilerOptions) {
        this.decompilerOptions = decompilerOptions;
        this.getOutputs().upToDateWhen(o -> false);
        this.getClasspath().from(new Object[]{decompilerOptions.getClasspath()}).finalizeValueOnRead();
        this.dependsOn(new Object[]{decompilerOptions.getClasspath().getBuiltBy()});
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        this.getDecompileCacheFile().set(extension.getFiles().getDecompileCache(CACHE_VERSION));
        this.getUnpickRuntimeClasspath().from(new Object[]{this.getProject().getConfigurations().getByName("unpick")});
        this.getUseCache().convention((Object)true);
        this.getResetCache().convention((Object)extension.refreshDeps());
    }

    @TaskAction
    public void run() throws IOException {
        Platform platform = Platform.CURRENT;
        if (!platform.getArchitecture().is64Bit()) {
            throw new UnsupportedOperationException("GenSources task requires a 64bit JVM to run due to the memory requirements.");
        }
        if (!((Boolean)this.getUseCache().get()).booleanValue()) {
            try (Timer timer = new Timer("Decompiled sources");){
                this.runWithoutCache();
            }
            catch (Exception e) {
                ExceptionUtil.processException(e, this.getProject());
                throw ExceptionUtil.createDescriptiveWrapper(RuntimeException::new, "Failed to decompile", e);
            }
            return;
        }
        LOGGER.info("Using decompile cache.");
        try (Timer timer = new Timer("Decompiled sources with cache");){
            Path cacheFile = ((File)this.getDecompileCacheFile().getAsFile().get()).toPath();
            if (((Boolean)this.getResetCache().get()).booleanValue()) {
                LOGGER.warn("Resetting decompile cache");
                Files.deleteIfExists(cacheFile);
            }
            Files.createDirectories(cacheFile.getParent(), new FileAttribute[0]);
            try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(cacheFile, true);){
                this.runWithCache(fs.getRoot());
            }
        }
        catch (Exception e) {
            ExceptionUtil.processException(e, this.getProject());
            throw ExceptionUtil.createDescriptiveWrapper(RuntimeException::new, "Failed to decompile", e);
        }
    }

    private void runWithCache(Path cacheRoot) throws IOException {
        CachedJarProcessor.WorkRequest workRequest;
        MinecraftJar minecraftJar = this.rebuildInputJar();
        CachedFileStoreImpl.CacheRules cacheRules = new CachedFileStoreImpl.CacheRules(50000L, Duration.ofDays(90L));
        CachedFileStoreImpl<CachedData> decompileCache = new CachedFileStoreImpl<CachedData>(cacheRoot, CachedData.SERIALIZER, cacheRules);
        String cacheKey = this.getCacheKey();
        CachedJarProcessor cachedJarProcessor = new CachedJarProcessor(decompileCache, cacheKey);
        LOGGER.info("Decompile cache key: {}", (Object)cacheKey);
        try (Timer timer = new Timer("Prepare job");){
            workRequest = cachedJarProcessor.prepareJob(minecraftJar.getPath());
        }
        CachedJarProcessor.WorkJob job = workRequest.job();
        CachedJarProcessor.CacheStats cacheStats = workRequest.stats();
        this.getProject().getLogger().lifecycle("Decompile cache stats: {} hits, {} misses", new Object[]{cacheStats.hits(), cacheStats.misses()});
        ClassLineNumbers outputLineNumbers = null;
        if (job instanceof CachedJarProcessor.WorkToDoJob) {
            Timer timer;
            Path existingClasses;
            CachedJarProcessor.WorkToDoJob workToDoJob = (CachedJarProcessor.WorkToDoJob)job;
            Path inputJar = workToDoJob.incomplete();
            if (job instanceof CachedJarProcessor.PartialWorkJob) {
                CachedJarProcessor.PartialWorkJob partialWorkJob = (CachedJarProcessor.PartialWorkJob)job;
                v0 = partialWorkJob.existingClasses();
            } else {
                v0 = existingClasses = null;
            }
            if (this.getUnpickDefinitions().isPresent()) {
                timer = new Timer("Unpick");
                try {
                    inputJar = this.unpickJar(inputJar, existingClasses);
                }
                finally {
                    timer.close();
                }
            }
            timer = new Timer("Decompile");
            try {
                outputLineNumbers = this.runDecompileJob(inputJar, workToDoJob.output(), existingClasses);
                this.removeForgeInnerClassSources(workToDoJob.output());
                outputLineNumbers = this.filterForgeLineNumbers(outputLineNumbers);
            }
            finally {
                timer.close();
            }
            if (Files.notExists(workToDoJob.output(), new LinkOption[0])) {
                throw new RuntimeException("Failed to decompile sources");
            }
        } else if (job instanceof CachedJarProcessor.CompletedWorkJob) {
            CachedJarProcessor.CompletedWorkJob completedWorkJob = (CachedJarProcessor.CompletedWorkJob)job;
        }
        Path sourcesJar = ((RegularFile)this.getOutputJar().get()).getAsFile().toPath();
        Files.deleteIfExists(sourcesJar);
        try (Timer timer = new Timer("Complete job");){
            cachedJarProcessor.completeJob(sourcesJar, job, outputLineNumbers);
        }
        LOGGER.info("Decompiled sources written to {}", (Object)sourcesJar);
        Path classesJar = minecraftJar.getPath();
        ClassLineNumbers existingLinenumbers = workRequest.lineNumbers();
        ClassLineNumbers lineNumbers = ClassLineNumbers.merge(existingLinenumbers, outputLineNumbers);
        if (lineNumbers == null) {
            LOGGER.info("No line numbers to remap, skipping remapping");
            return;
        }
        Path tempJar = Files.createTempFile("loom", "linenumber-remap.jar", new FileAttribute[0]);
        Files.delete(tempJar);
        try (Timer timer = new Timer("Remap line numbers");){
            this.remapLineNumbers(lineNumbers, classesJar, tempJar);
        }
        Files.move(tempJar, classesJar, StandardCopyOption.REPLACE_EXISTING);
        timer = new Timer("Prune cache");
        try {
            decompileCache.prune();
        }
        finally {
            timer.close();
        }
    }

    private void runWithoutCache() throws IOException {
        ClassLineNumbers lineNumbers;
        MinecraftJar minecraftJar = this.rebuildInputJar();
        Path inputJar = minecraftJar.getPath();
        Path sourcesJar = ((RegularFile)this.getOutputJar().get()).getAsFile().toPath();
        if (this.getUnpickDefinitions().isPresent()) {
            try (Timer timer = new Timer("Unpick");){
                inputJar = this.unpickJar(inputJar, null);
            }
        }
        try (Timer timer = new Timer("Decompile");){
            lineNumbers = this.runDecompileJob(inputJar, sourcesJar, null);
            this.removeForgeInnerClassSources(sourcesJar);
            lineNumbers = this.filterForgeLineNumbers(lineNumbers);
        }
        if (Files.notExists(sourcesJar, new LinkOption[0])) {
            throw new RuntimeException("Failed to decompile sources");
        }
        LOGGER.info("Decompiled sources written to {}", (Object)sourcesJar);
        if (lineNumbers == null) {
            LOGGER.info("No line numbers to remap, skipping remapping");
            return;
        }
        Path classesJar = minecraftJar.getPath();
        Path tempJar = Files.createTempFile("loom", "linenumber-remap.jar", new FileAttribute[0]);
        Files.delete(tempJar);
        try (Timer timer = new Timer("Remap line numbers");){
            this.remapLineNumbers(lineNumbers, classesJar, tempJar);
        }
        Files.move(tempJar, classesJar, StandardCopyOption.REPLACE_EXISTING);
    }

    private String getCacheKey() {
        StringJoiner sj = new StringJoiner(",");
        sj.add(this.getDecompilerCheckKey());
        sj.add(this.getUnpickCacheKey());
        LOGGER.info("Decompile cache data: {}", (Object)sj);
        try {
            return Checksum.sha256Hex(sj.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String getDecompilerCheckKey() {
        StringJoiner sj = new StringJoiner(",");
        sj.add((CharSequence)this.decompilerOptions.getDecompilerClassName().get());
        sj.add(GenerateSourcesTask.fileCollectionHash((FileCollection)this.decompilerOptions.getClasspath()));
        for (Map.Entry entry : ((Map)this.decompilerOptions.getOptions().get()).entrySet()) {
            sj.add((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        return sj.toString();
    }

    private String getUnpickCacheKey() {
        if (!this.getUnpickDefinitions().isPresent()) {
            return "";
        }
        StringJoiner sj = new StringJoiner(",");
        sj.add(GenerateSourcesTask.fileHash((File)this.getUnpickDefinitions().getAsFile().get()));
        sj.add(GenerateSourcesTask.fileCollectionHash((FileCollection)this.getUnpickConstantJar()));
        sj.add(GenerateSourcesTask.fileCollectionHash((FileCollection)this.getUnpickRuntimeClasspath()));
        return sj.toString();
    }

    @Nullable
    private ClassLineNumbers runDecompileJob(Path inputJar, Path outputJar, @Nullable Path existingJar) throws IOException {
        Platform platform = Platform.CURRENT;
        Path lineMapFile = File.createTempFile("loom", "linemap").toPath();
        Files.delete(lineMapFile);
        if (!platform.supportsUnixDomainSockets()) {
            this.getProject().getLogger().warn("Decompile worker logging disabled as Unix Domain Sockets is not supported on your operating system.");
            this.doWork(null, inputJar, outputJar, lineMapFile, existingJar);
            if (this.getExtension().isForgeLike()) {
                try (ScopedSharedServiceManager serviceManager = new ScopedSharedServiceManager();){
                    ForgeSourcesRemapper.addForgeSources(this.getProject(), serviceManager, inputJar, outputJar);
                }
            }
            return GenerateSourcesTask.readLineNumbers(lineMapFile);
        }
        Path ipcPath = Files.createTempFile("loom", "ipc", new FileAttribute[0]);
        Files.deleteIfExists(ipcPath);
        try (ThreadedProgressLoggerConsumer loggerConsumer = new ThreadedProgressLoggerConsumer(this.getProject(), this.decompilerOptions.getName(), "Decompiling minecraft sources");
             IPCServer logReceiver = new IPCServer(ipcPath, loggerConsumer);){
            this.doWork(logReceiver, inputJar, outputJar, lineMapFile, existingJar);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to shutdown log receiver", e);
        }
        finally {
            Files.deleteIfExists(ipcPath);
        }
        if (this.getExtension().isForgeLike()) {
            try (ScopedSharedServiceManager serviceManager = new ScopedSharedServiceManager();){
                ForgeSourcesRemapper.addForgeSources(this.getProject(), serviceManager, inputJar, outputJar);
            }
        }
        return GenerateSourcesTask.readLineNumbers(lineMapFile);
    }

    @Nullable
    private ClassLineNumbers filterForgeLineNumbers(@Nullable ClassLineNumbers lineNumbers) {
        if (lineNumbers == null) {
            return null;
        }
        if (this.getExtension().isForgeLike()) {
            HashMap<String, ClassLineNumbers.Entry> lineMap = new HashMap<String, ClassLineNumbers.Entry>();
            for (Map.Entry<String, ClassLineNumbers.Entry> entry : lineNumbers.lineMap().entrySet()) {
                String name = entry.getKey();
                if (name.startsWith("net/minecraftforge/") || name.startsWith("net/neoforged/")) continue;
                lineMap.put(name, entry.getValue());
            }
            return new ClassLineNumbers(lineMap);
        }
        return lineNumbers;
    }

    private void removeForgeInnerClassSources(Path sourcesJar) throws IOException {
        if (!this.getExtension().isForgeLike()) {
            return;
        }
        try (FileSystemUtil.Delegate outputFs = FileSystemUtil.getJarFileSystem(sourcesJar, false);
             Stream<Path> walk = Files.walk(outputFs.getRoot(), new FileVisitOption[0]);){
            Iterator iterator = walk.iterator();
            while (iterator.hasNext()) {
                Path fsPath = (Path)iterator.next();
                if (fsPath.startsWith("/META-INF/") || !Files.isRegularFile(fsPath, new LinkOption[0]) || fsPath.toString().substring(outputFs.getRoot().toString().length()).indexOf(36) == -1) continue;
                Files.delete(fsPath);
            }
        }
    }

    private MinecraftJar rebuildInputJar() {
        List<MinecraftJar> minecraftJars;
        try (ScopedSharedServiceManager serviceManager = new ScopedSharedServiceManager();){
            ConfigContextImpl configContext = new ConfigContextImpl(this.getProject(), serviceManager, this.getExtension());
            AbstractMappedMinecraftProvider.ProvideContext provideContext = new AbstractMappedMinecraftProvider.ProvideContext(false, true, configContext);
            minecraftJars = this.getExtension().getNamedMinecraftProvider().provide(provideContext);
        }
        catch (Exception e) {
            throw ExceptionUtil.createDescriptiveWrapper(RuntimeException::new, "Failed to rebuild input jars", e);
        }
        for (MinecraftJar minecraftJar : minecraftJars) {
            if (!minecraftJar.getName().equals(this.getInputJarName().get())) continue;
            return minecraftJar;
        }
        throw new IllegalStateException("Could not find minecraft jar (%s) but got (%s)".formatted(this.getInputJarName().get(), minecraftJars.stream().map(MinecraftJar::getName).collect(Collectors.joining(", "))));
    }

    private Path unpickJar(Path inputJar, @Nullable Path existingClasses) {
        Path outputJar = ((RegularFile)this.getUnpickOutputJar().get()).getAsFile().toPath();
        List<String> args = this.getUnpickArgs(inputJar, outputJar, existingClasses);
        ExecResult result = this.getExecOperations().javaexec(spec -> {
            spec.getMainClass().set((Object)"daomephsta.unpick.cli.Main");
            spec.classpath(new Object[]{this.getUnpickRuntimeClasspath()});
            spec.args((Iterable)args);
            spec.systemProperty("java.util.logging.config.file", (Object)this.writeUnpickLogConfig().getAbsolutePath());
        });
        result.rethrowFailure();
        return outputJar;
    }

    private List<String> getUnpickArgs(Path inputJar, Path outputJar, @Nullable Path existingClasses) {
        ArrayList<File> fileArgs = new ArrayList<File>();
        fileArgs.add(inputJar.toFile());
        fileArgs.add(outputJar.toFile());
        fileArgs.add(((RegularFile)this.getUnpickDefinitions().get()).getAsFile());
        fileArgs.add(this.getUnpickConstantJar().getSingleFile());
        for (Path minecraftJar : this.getExtension().getMinecraftJars(MappingsNamespace.NAMED)) {
            fileArgs.add(minecraftJar.toFile());
        }
        for (File file : this.getUnpickClasspath()) {
            fileArgs.add(file);
        }
        if (existingClasses != null) {
            fileArgs.add(existingClasses.toFile());
        }
        return fileArgs.stream().map(File::getAbsolutePath).toList();
    }

    private File writeUnpickLogConfig() {
        File unpickLoggingConfigFile = this.getExtension().getFiles().getUnpickLoggingConfigFile();
        try (InputStream is = GenerateSourcesTask.class.getClassLoader().getResourceAsStream("unpick-logging.properties");){
            Files.deleteIfExists(unpickLoggingConfigFile.toPath());
            Files.copy(Objects.requireNonNull(is), unpickLoggingConfigFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new org.gradle.api.UncheckedIOException("Failed to copy unpick logging config", (Throwable)e);
        }
        return unpickLoggingConfigFile;
    }

    private void remapLineNumbers(ClassLineNumbers lineNumbers, Path inputJar, Path outputJar) throws IOException {
        Objects.requireNonNull(lineNumbers, "lineNumbers");
        LineNumberRemapper remapper = new LineNumberRemapper(lineNumbers);
        remapper.process(inputJar, outputJar);
        Path lineMap = inputJar.resolveSibling(String.valueOf(inputJar.getFileName()) + ".linemap.txt");
        try (BufferedWriter writer = Files.newBufferedWriter(lineMap, new OpenOption[0]);){
            lineNumbers.write(writer);
        }
        LOGGER.info("Wrote linemap to {}", (Object)lineMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork(@Nullable IPCServer ipcServer, Path inputJar, Path outputJar, Path linemapFile, @Nullable Path existingClasses) {
        String jvmMarkerValue = UUID.randomUUID().toString();
        WorkQueue workQueue = this.createWorkQueue(jvmMarkerValue);
        ConfigurableFileCollection classpath = this.getProject().files(new Object[0]);
        classpath.from(new Object[]{this.getProject().getConfigurations().getByName("minecraftLibraries")});
        if (existingClasses != null) {
            classpath.from(new Object[]{existingClasses});
        }
        workQueue.submit(DecompileAction.class, params -> {
            params.getDecompilerOptions().set((Object)this.decompilerOptions.toDto());
            params.getInputJar().set(inputJar.toFile());
            params.getOutputJar().set(outputJar.toFile());
            params.getLinemapFile().set(linemapFile.toFile());
            params.getMappings().set(this.getMappings().toFile());
            if (ipcServer != null) {
                params.getIPCPath().set(ipcServer.getPath().toFile());
            }
            params.getClassPath().setFrom((Iterable)classpath);
            params.getForge().set((Object)this.getExtension().isForgeLike());
        });
        try {
            workQueue.await();
        }
        finally {
            boolean stopped;
            if (ipcServer != null && !(stopped = WorkerDaemonClientsManagerHelper.stopIdleJVM(this.getWorkerDaemonClientsManager(), jvmMarkerValue)) && ipcServer.hasReceivedMessage()) {
                LOGGER.info("Failed to stop decompile worker JVM, it may have already been stopped?");
            }
        }
    }

    private WorkQueue createWorkQueue(String jvmMarkerValue) {
        if (!this.useProcessIsolation()) {
            return this.getWorkerExecutor().classLoaderIsolation(spec -> spec.getClasspath().from(new Object[]{this.getClasspath()}));
        }
        return this.getWorkerExecutor().processIsolation(spec -> {
            spec.forkOptions(forkOptions -> {
                forkOptions.setMinHeapSize(String.format(Locale.ENGLISH, "%dm", Math.min(512L, (Long)this.decompilerOptions.getMemory().get())));
                forkOptions.setMaxHeapSize(String.format(Locale.ENGLISH, "%dm", this.decompilerOptions.getMemory().get()));
                forkOptions.systemProperty("fabric.loom.decompile.worker", (Object)jvmMarkerValue);
            });
            spec.getClasspath().from(new Object[]{this.getClasspath()});
        });
    }

    private boolean useProcessIsolation() {
        return !Boolean.getBoolean("fabric.loom.genSources.debug");
    }

    private Path getMappings() {
        Path outputMappings;
        Path inputMappings = this.getExtension().getPlatformMappingFile();
        MemoryMappingTree mappingTree = new MemoryMappingTree();
        try (BufferedReader reader = Files.newBufferedReader(inputMappings, StandardCharsets.UTF_8);){
            MappingReader.read((Reader)reader, (MappingVisitor)new MappingSourceNsSwitch((MappingVisitor)mappingTree, MappingsNamespace.INTERMEDIARY.toString()));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read mappings", e);
        }
        ArrayList<MappingsProcessor> mappingsProcessors = new ArrayList<MappingsProcessor>();
        MinecraftJarProcessorManager minecraftJarProcessorManager = MinecraftJarProcessorManager.create(this.getProject());
        if (minecraftJarProcessorManager != null) {
            mappingsProcessors.add(mappings -> {
                try (ScopedSharedServiceManager serviceManager = new ScopedSharedServiceManager();){
                    ConfigContextImpl configContext = new ConfigContextImpl(this.getProject(), serviceManager, this.getExtension());
                    boolean bl = minecraftJarProcessorManager.processMappings(mappings, new MappingProcessorContextImpl(configContext));
                    return bl;
                }
            });
        }
        if (mappingsProcessors.isEmpty()) {
            return inputMappings;
        }
        boolean transformed = false;
        for (MappingsProcessor mappingsProcessor : mappingsProcessors) {
            if (!mappingsProcessor.transform(mappingTree)) continue;
            transformed = true;
        }
        if (!transformed) {
            return inputMappings;
        }
        try {
            outputMappings = Files.createTempFile("loom-transitive-mappings", ".tiny", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temp file", e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(outputMappings, StandardCharsets.UTF_8, new OpenOption[0]);){
            Tiny2FileWriter tiny2Writer = new Tiny2FileWriter((Writer)writer, false);
            mappingTree.accept((MappingVisitor)new MappingSourceNsSwitch((MappingVisitor)tiny2Writer, MappingsNamespace.NAMED.toString()));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write mappings", e);
        }
        return outputMappings;
    }

    public static File getJarFileWithSuffix(String suffix, Path runtimeJar) {
        String path = runtimeJar.toFile().getAbsolutePath();
        if (!path.toLowerCase(Locale.ROOT).endsWith(".jar")) {
            throw new RuntimeException("Invalid mapped JAR path: " + path);
        }
        return new File(path.substring(0, path.length() - 4) + suffix);
    }

    static File getJarFileWithSuffix(RegularFileProperty runtimeJar, String suffix) {
        return GenerateSourcesTask.getJarFileWithSuffix(suffix, ((RegularFile)runtimeJar.get()).getAsFile().toPath());
    }

    @Nullable
    private static ClassLineNumbers readLineNumbers(Path linemapFile) throws IOException {
        if (Files.notExists(linemapFile, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(linemapFile, StandardCharsets.UTF_8);){
            ClassLineNumbers classLineNumbers = ClassLineNumbers.readMappings(reader);
            return classLineNumbers;
        }
    }

    private static Constructor<LoomDecompiler> getDecompilerConstructor(String clazz) {
        try {
            return Class.forName(clazz).getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static String fileHash(File file) {
        try {
            return Checksum.sha256Hex(Files.readAllBytes(file.toPath()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String fileCollectionHash(FileCollection files) {
        StringJoiner sj = new StringJoiner(",");
        files.getFiles().stream().sorted(Comparator.comparing(File::getAbsolutePath)).map(GenerateSourcesTask::fileHash).forEach(sj::add);
        return sj.toString();
    }

    private final class Timer
    implements AutoCloseable {
        private final String name;
        private final long start;

        Timer(String name) {
            this.name = name;
            this.start = System.currentTimeMillis();
        }

        @Override
        public void close() {
            GenerateSourcesTask.this.getProject().getLogger().info("{} took {}ms", (Object)this.name, (Object)(System.currentTimeMillis() - this.start));
        }
    }

    public static abstract class DecompileAction
    implements WorkAction<DecompileParams> {
        public void execute() {
            block11: {
                block10: {
                    if (!((DecompileParams)this.getParameters()).getIPCPath().isPresent()) break block10;
                    if (Platform.CURRENT.supportsUnixDomainSockets()) break block11;
                }
                this.doDecompile(System.out::println);
                return;
            }
            Path ipcPath = ((RegularFile)((DecompileParams)this.getParameters()).getIPCPath().get()).getAsFile().toPath();
            try (IPCClient ipcClient = new IPCClient(ipcPath);){
                this.doDecompile(new ThreadedSimpleProgressLogger(ipcClient));
            }
            catch (Exception e) {
                throw ExceptionUtil.createDescriptiveWrapper(RuntimeException::new, "Failed to decompile", e);
            }
        }

        private void doDecompile(IOStringConsumer logger) {
            LoomDecompiler decompiler;
            Path inputJar = ((RegularFile)((DecompileParams)this.getParameters()).getInputJar().get()).getAsFile().toPath();
            Path linemap = ((RegularFile)((DecompileParams)this.getParameters()).getLinemapFile().get()).getAsFile().toPath();
            Path outputJar = ((RegularFile)((DecompileParams)this.getParameters()).getOutputJar().get()).getAsFile().toPath();
            DecompilerOptions.Dto decompilerOptions = (DecompilerOptions.Dto)((DecompileParams)this.getParameters()).getDecompilerOptions().get();
            try {
                String className = decompilerOptions.className();
                Constructor<LoomDecompiler> decompilerConstructor = GenerateSourcesTask.getDecompilerConstructor(className);
                Objects.requireNonNull(decompilerConstructor, "%s must have a no args constructor".formatted(className));
                decompiler = decompilerConstructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException("Failed to create decompiler", e);
            }
            DecompilationMetadata metadata = new DecompilationMetadata(decompilerOptions.maxThreads(), ((RegularFile)((DecompileParams)this.getParameters()).getMappings().get()).getAsFile().toPath(), this.getLibraries(), logger, decompilerOptions.options());
            decompiler.decompile(inputJar, outputJar, linemap, metadata);
            try {
                metadata.logger().accept("LOOM_CLOSE_LOGGERS");
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close loggers", e);
            }
        }

        private Collection<Path> getLibraries() {
            return DecompileAction.toPaths((FileCollection)((DecompileParams)this.getParameters()).getClassPath());
        }

        static Collection<Path> toPaths(FileCollection files) {
            return files.getFiles().stream().map(File::toPath).collect(Collectors.toSet());
        }
    }

    public static interface MappingsProcessor {
        public boolean transform(MemoryMappingTree var1);
    }

    public static interface DecompileParams
    extends WorkParameters {
        public Property<DecompilerOptions.Dto> getDecompilerOptions();

        public RegularFileProperty getInputJar();

        public RegularFileProperty getOutputJar();

        public RegularFileProperty getLinemapFile();

        public RegularFileProperty getMappings();

        public RegularFileProperty getIPCPath();

        public ConfigurableFileCollection getClassPath();

        public Property<Boolean> getForge();
    }
}

