/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import codechicken.diffpatch.cli.CliOperation;
import codechicken.diffpatch.cli.PatchOperation;
import codechicken.diffpatch.util.LoggingOutputStream;
import codechicken.diffpatch.util.PatchMode;
import dev.architectury.loom.util.TempFiles;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loom.configuration.processors.MinecraftJarProcessorManager;
import net.fabricmc.loom.configuration.providers.forge.ForgeUserdevProvider;
import net.fabricmc.loom.configuration.providers.forge.MinecraftPatchedProvider;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.McpExecutor;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.ConstantLogic;
import net.fabricmc.loom.configuration.sources.ForgeSourcesRemapper;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.task.GenerateSourcesTask;
import net.fabricmc.loom.util.SourceRemapper;
import net.fabricmc.loom.util.service.ScopedSharedServiceManager;
import net.fabricmc.loom.util.service.SharedServiceManager;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaExecSpec;
import org.jetbrains.annotations.Nullable;

public abstract class GenerateForgePatchedSourcesTask
extends AbstractLoomTask {
    @InputFile
    public abstract RegularFileProperty getInputJar();

    @InputFile
    public abstract RegularFileProperty getRuntimeJar();

    @OutputFile
    public abstract RegularFileProperty getOutputJar();

    public GenerateForgePatchedSourcesTask() {
        this.getOutputs().upToDateWhen(o -> false);
        this.getOutputJar().fileProvider(this.getProject().provider(() -> GenerateSourcesTask.getJarFileWithSuffix(this.getRuntimeJar(), "-sources.jar")));
    }

    @TaskAction
    public void run() throws IOException {
        @Nullable MinecraftJarProcessorManager jarProcessorManager = MinecraftJarProcessorManager.create(this.getProject());
        if (jarProcessorManager != null) {
            throw new UnsupportedOperationException("Cannot run Forge's patched decompilation with a processed Minecraft jar");
        }
        try (TempFiles tempFiles = new TempFiles();
             ScopedSharedServiceManager serviceManager = new ScopedSharedServiceManager();){
            Path cache = tempFiles.directory("loom-decompilation");
            Path accessTransformed = cache.resolve("access-transformed.jar");
            MinecraftPatchedProvider.accessTransform(this.getProject(), ((RegularFile)this.getInputJar().get()).getAsFile().toPath(), accessTransformed);
            Path sideAnnotationStripped = cache.resolve("side-annotation-stripped.jar");
            this.stripSideAnnotations(accessTransformed, sideAnnotationStripped);
            Path rawDecompiled = this.decompileAndPatch(cache, sideAnnotationStripped);
            this.getLogger().lifecycle(":applying Forge patches");
            Path patched = this.sourcePatch(cache, rawDecompiled);
            this.remap(patched, serviceManager);
            ForgeSourcesRemapper.addForgeSources(this.getProject(), serviceManager, null, ((RegularFile)this.getOutputJar().get()).getAsFile().toPath());
        }
    }

    private Path decompileAndPatch(Path cache, Path gameJar) throws IOException {
        Path mcpCache = cache.resolve("mcp");
        Files.createDirectory(mcpCache, new FileAttribute[0]);
        MinecraftPatchedProvider patchedProvider = MinecraftPatchedProvider.get(this.getProject());
        McpExecutor mcp = patchedProvider.createMcpExecutor(mcpCache);
        mcp.setStepLogicProvider((name, type) -> {
            if (name.equals("rename")) {
                return Optional.of(new ConstantLogic(() -> gameJar));
            }
            return Optional.empty();
        });
        mcp.enqueue("decompile");
        mcp.enqueue("patch");
        return mcp.execute();
    }

    private Path sourcePatch(Path cache, Path rawDecompiled) throws IOException {
        ForgeUserdevProvider userdev = this.getExtension().getForgeUserdevProvider();
        String patchPathInZip = userdev.getConfig().patches();
        Path output = cache.resolve("patched.jar");
        Path rejects = cache.resolve("rejects");
        CliOperation.Result result = PatchOperation.builder().logTo((OutputStream)new LoggingOutputStream(this.getLogger(), LogLevel.INFO)).basePath(rawDecompiled).patchesPath(userdev.getUserdevJar().toPath()).patchesPrefix(patchPathInZip).outputPath(output).mode(PatchMode.ACCESS).rejectsPath(rejects).aPrefix(userdev.getConfig().patchesOriginalPrefix().orElseThrow()).bPrefix(userdev.getConfig().patchesModifiedPrefix().orElseThrow()).build().operate();
        if (result.exit != 0) {
            throw new RuntimeException("Could not patch " + String.valueOf(rawDecompiled) + "; rejects saved to " + String.valueOf(rejects.toAbsolutePath()));
        }
        return output;
    }

    private void remap(Path input, SharedServiceManager serviceManager) {
        SourceRemapper remapper = new SourceRemapper(this.getProject(), serviceManager, "srg", "named");
        remapper.scheduleRemapSources(input.toFile(), ((RegularFile)this.getOutputJar().get()).getAsFile(), false, true, () -> {});
        remapper.remapAll();
    }

    /*
     * Exception decompiling
     */
    private void stripSideAnnotations(Path input, Path output) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void lambda$stripSideAnnotations$5(FileCollection classpath, Path input, Path output, List sasPaths, JavaExecSpec spec) {
        spec.setClasspath(classpath);
        spec.args(new Object[]{"--strip", "--input", input.toAbsolutePath().toString(), "--output", output.toAbsolutePath().toString()});
        for (Path sasPath : sasPaths) {
            spec.args(new Object[]{"--data", sasPath.toAbsolutePath().toString()});
        }
    }
}

