/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ide.RunConfig;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.task.AbstractLoomTask;
import org.apache.commons.io.FileUtils;
import org.gradle.api.tasks.TaskAction;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;

public class GenEclipseRunsTask
extends AbstractLoomTask {
    @TaskAction
    public void genRuns() throws IOException {
        EclipseModel eclipseModel = (EclipseModel)this.getProject().getExtensions().getByType(EclipseModel.class);
        LoomGradleExtension extension = this.getExtension();
        File dataRunConfigs = new File(this.getProject().getRootDir(), eclipseModel.getProject().getName() + "_data.launch");
        for (RunConfigSettings settings : extension.getRunConfigs()) {
            if (!settings.isIdeConfigGenerated()) continue;
            String name = settings.getName();
            File configs = new File(this.getProject().getProjectDir(), eclipseModel.getProject().getName() + "_" + name + ".launch");
            RunConfig configInst = RunConfig.runConfig(this.getProject(), settings);
            String config = configInst.fromDummy("eclipse_run_config_template.xml", false, this.getProject());
            if (!configs.exists()) {
                FileUtils.writeStringToFile((File)configs, (String)config, (Charset)StandardCharsets.UTF_8);
            }
            settings.makeRunDir();
        }
    }
}

