/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import net.fabricmc.loom.decompilers.cache.ClassEntry;
import net.fabricmc.loom.util.CompletableFutureCollector;
import net.fabricmc.loom.util.FileSystemUtil;
import org.gradle.api.JavaVersion;
import org.objectweb.asm.ClassReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JarWalker {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarWalker.class);

    private JarWalker() {
    }

    public static List<ClassEntry> findClasses(Path jar) throws IOException {
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(jar);){
            List<ClassEntry> list = JarWalker.findClasses(fs);
            return list;
        }
    }

    public static List<ClassEntry> findClasses(FileSystemUtil.Delegate fs) throws IOException {
        ArrayList<String> outerClasses = new ArrayList<String>();
        HashMap<String, List> innerClasses = new HashMap<String, List>();
        try (Stream<Path> walk = Files.walk(fs.getRoot(), new FileVisitOption[0]);){
            Iterator iterator = walk.iterator();
            while (iterator.hasNext()) {
                String fileName;
                Path entry = (Path)iterator.next();
                if (!Files.isRegularFile(entry, new LinkOption[0]) || !(fileName = entry.toString().substring(fs.getRoot().toString().length())).endsWith(".class")) continue;
                boolean isInnerClass = fileName.contains("$");
                if (isInnerClass) {
                    String outerClassName = fileName.substring(0, fileName.indexOf(36)) + ".class";
                    innerClasses.computeIfAbsent(outerClassName, k -> new ArrayList()).add(fileName);
                    continue;
                }
                outerClasses.add(fileName);
            }
        }
        LOGGER.info("Found {} outer classes and {} inner classes", (Object)outerClasses.size(), (Object)innerClasses.size());
        Collections.sort(outerClasses);
        Executor executor = JarWalker.getExecutor();
        ArrayList<CompletableFuture<ClassEntry>> classEntries = new ArrayList<CompletableFuture<ClassEntry>>();
        for (String outerClass : outerClasses) {
            List<String> innerClasList = (List<String>)innerClasses.get(outerClass);
            if (innerClasList == null) {
                innerClasList = Collections.emptyList();
            } else {
                Collections.sort(innerClasList);
            }
            classEntries.add(JarWalker.getClassEntry(outerClass, innerClasList, fs, executor));
        }
        try {
            return classEntries.stream().collect(CompletableFutureCollector.allOf()).get(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException("Failed to get class entries", e);
        }
    }

    private static CompletableFuture<ClassEntry> getClassEntry(String outerClass, List<String> innerClasses, FileSystemUtil.Delegate fs, Executor executor) {
        ArrayList<CompletableFuture<List>> parentClassesFutures = new ArrayList<CompletableFuture<List>>();
        parentClassesFutures.add(CompletableFuture.supplyAsync(() -> JarWalker.getSuperClasses(outerClass, fs), executor));
        for (String innerClass : innerClasses) {
            parentClassesFutures.add(CompletableFuture.supplyAsync(() -> JarWalker.getSuperClasses(innerClass, fs), executor));
        }
        return ((CompletableFuture)parentClassesFutures.stream().collect(CompletableFutureCollector.allOf()).thenApply(lists -> lists.stream().flatMap(Collection::stream).filter(JarWalker::isNotReservedClass).distinct().toList())).thenApply(parentClasses -> new ClassEntry(outerClass, innerClasses, (List<String>)parentClasses));
    }

    private static List<String> getSuperClasses(String classFile, FileSystemUtil.Delegate fs) {
        List<String> list;
        block9: {
            InputStream is = Files.newInputStream(fs.getPath(classFile, new String[0]), new OpenOption[0]);
            try {
                ClassReader reader = new ClassReader(is);
                ArrayList<String> parentClasses = new ArrayList<String>();
                String superName = reader.getSuperName();
                if (superName != null) {
                    parentClasses.add(superName);
                }
                Collections.addAll(parentClasses, reader.getInterfaces());
                list = Collections.unmodifiableList(parentClasses);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to read class file: " + classFile, e);
                }
            }
            is.close();
        }
        return list;
    }

    private static Executor getExecutor() {
        if (JavaVersion.current().isCompatibleWith(JavaVersion.VERSION_21)) {
            try {
                Method m = Executors.class.getMethod("newVirtualThreadPerTaskExecutor", new Class[0]);
                return (ExecutorService)m.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Failed to create virtual thread executor", e);
            }
        }
        return ForkJoinPool.commonPool();
    }

    private static boolean isNotReservedClass(String name) {
        return !"java/lang/Object".equals(name);
    }
}

