/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.loom.decompilers.ClassLineNumbers;
import net.fabricmc.loom.util.AsyncZipProcessor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record LineNumberRemapper(ClassLineNumbers lineNumbers) {
    private static final Logger LOGGER = LoggerFactory.getLogger(LineNumberRemapper.class);

    public void process(Path input, Path output) throws IOException {
        AsyncZipProcessor.processEntries(input, output, new AsyncZipProcessor(){
            private final Set<Path> createdParents = new HashSet<Path>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processEntryAsync(Path file, Path dst) throws IOException {
                Path parent = dst.getParent();
                Set<Path> set = this.createdParents;
                synchronized (set) {
                    if (parent != null && this.createdParents.add(parent)) {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                }
                String fileName = file.toAbsolutePath().toString();
                if (fileName.endsWith(".class")) {
                    String idx = fileName.substring(1, fileName.length() - 6);
                    int dollarPos = idx.indexOf(36);
                    if (dollarPos >= 0) {
                        idx = idx.substring(0, dollarPos);
                    }
                    if (LineNumberRemapper.this.lineNumbers.lineMap().containsKey(idx)) {
                        LOGGER.debug("Remapping line numbers for class: {}", (Object)idx);
                        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                            ClassReader reader = new ClassReader(is);
                            ClassWriter writer = new ClassWriter(0);
                            reader.accept((ClassVisitor)new LineNumberVisitor(589824, (ClassVisitor)writer, LineNumberRemapper.this.lineNumbers.lineMap().get(idx)), 0);
                            Files.write(dst, writer.toByteArray(), new OpenOption[0]);
                            return;
                        }
                    }
                    LOGGER.debug("No linemap found for: {}", (Object)idx);
                }
                Files.copy(file, dst, StandardCopyOption.REPLACE_EXISTING);
            }
        });
    }

    private static class LineNumberVisitor
    extends ClassVisitor {
        private final ClassLineNumbers.Entry lineNumbers;

        LineNumberVisitor(int api, ClassVisitor classVisitor, ClassLineNumbers.Entry lineNumbers) {
            super(api, classVisitor);
            this.lineNumbers = lineNumbers;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            return new MethodVisitor(this.api, super.visitMethod(access, name, descriptor, signature, exceptions)){

                public void visitLineNumber(int line, Label start) {
                    int tLine = line;
                    if (tLine <= 0) {
                        super.visitLineNumber(line, start);
                    } else if (tLine >= lineNumbers.maxLine()) {
                        super.visitLineNumber(lineNumbers.maxLineDest(), start);
                    } else {
                        Integer matchedLine = null;
                        while (tLine <= lineNumbers.maxLine() && (matchedLine = lineNumbers.lineMap().get(tLine)) == null) {
                            ++tLine;
                        }
                        super.visitLineNumber(matchedLine != null ? matchedLine.intValue() : lineNumbers.maxLineDest(), start);
                    }
                }
            };
        }
    }
}

