/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.sandbox;

import java.nio.file.Path;
import java.util.Objects;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.configuration.sandbox.SandboxMetadata;
import net.fabricmc.loom.util.Platform;
import net.fabricmc.loom.util.gradle.GradleUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SandboxConfiguration
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SandboxConfiguration.class);

    @Inject
    protected abstract Project getProject();

    @Inject
    public abstract DependencyFactory getDependencyFactory();

    @Override
    public void run() {
        if (this.getProject().findProperty("fabric.loom.experimental.sandbox") == null) {
            LOGGER.debug("No fabric sandbox property set");
            return;
        }
        GradleUtils.afterSuccessfulEvaluation(this.getProject(), this::evaluate);
    }

    private void evaluate() {
        String sandboxNotation = (String)Objects.requireNonNull(this.getProject().findProperty("fabric.loom.experimental.sandbox"));
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        ExternalModuleDependency dependency = this.getDependencyFactory().create((CharSequence)sandboxNotation);
        Configuration configuration = this.getProject().getConfigurations().detachedConfiguration(new Dependency[]{dependency});
        Path sandboxJar = configuration.getSingleFile().toPath();
        SandboxMetadata metadata = SandboxMetadata.readFromJar(sandboxJar);
        if (!metadata.supportsPlatform(Platform.CURRENT)) {
            LOGGER.info("Sandbox does not support the current platform");
            return;
        }
        this.getProject().getDependencies().add("runtimeOnly", (Object)dependency);
        extension.getRuns().create("clientSandbox", settings -> {
            RunConfigSettings clientRun = (RunConfigSettings)extension.getRuns().getByName("client");
            settings.inherit(clientRun);
            settings.name("Client Sandbox");
            settings.devLaunchMainClass().set((Object)metadata.mainClass());
            settings.property("fabric.sandbox.realMain", (String)clientRun.getMainClass().get());
        });
    }
}

