/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Queue;
import net.fabricmc.loom.api.manifest.VersionsManifestsAPI;

public class ManifestLocations
implements VersionsManifestsAPI,
Iterable<ManifestLocation> {
    private static final String FILE_EXTENSION = ".json";
    private final Queue<ManifestLocation> locations = new PriorityQueue<ManifestLocation>();
    private final String baseFileName;

    public ManifestLocations(String baseFileName) {
        this.baseFileName = baseFileName;
    }

    public void addBuiltIn(int priority, String url, String fileName) {
        this.locations.add(new ManifestLocation(priority, url, fileName));
    }

    @Override
    public void add(String url, int priority) {
        this.locations.add(new ManifestLocation(priority, url));
    }

    @Override
    public Iterator<ManifestLocation> iterator() {
        return this.locations.iterator();
    }

    public class ManifestLocation
    implements Comparable<ManifestLocation> {
        private final int priority;
        private final String url;
        private final String builtInFileName;

        private ManifestLocation(int priority, String url) {
            this(priority, url, null);
        }

        private ManifestLocation(int priority, String url, String builtInFileName) {
            this.priority = priority;
            this.url = url;
            this.builtInFileName = builtInFileName;
        }

        public boolean isBuiltIn() {
            return this.builtInFileName != null;
        }

        public String url() {
            return this.url;
        }

        public Path cacheFile(Path dir) {
            String fileName = this.builtInFileName != null ? this.builtInFileName + ManifestLocations.FILE_EXTENSION : ManifestLocations.this.baseFileName + "-" + Integer.toHexString(this.url.hashCode()) + ManifestLocations.FILE_EXTENSION;
            return dir.resolve(fileName);
        }

        @Override
        public int compareTo(ManifestLocation o) {
            return Integer.compare(this.priority, o.priority);
        }
    }
}

