/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.utils;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loom.api.mappings.layered.MappingContext;
import net.fabricmc.loom.api.mappings.layered.spec.FileSpec;
import net.fabricmc.loom.configuration.providers.mappings.GradleMappingContext;
import net.fabricmc.loom.util.gradle.SelfResolvingDependencyUtils;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.FileCollectionDependency;

public record DependencyFileSpec(Dependency dependency) implements FileSpec
{
    @Override
    public Path get(MappingContext context) {
        if (SelfResolvingDependencyUtils.isExplicitSRD(this.dependency)) {
            Set<File> files;
            if (context instanceof GradleMappingContext) {
                GradleMappingContext gradleMappingContext = (GradleMappingContext)context;
                gradleMappingContext.getExtension().getProblemReporter().reportSelfResolvingDependencyUsage();
            }
            if ((files = SelfResolvingDependencyUtils.resolve(this.dependency)).isEmpty()) {
                throw new RuntimeException("SelfResolvingDependency (%s) resolved no files".formatted(this.dependency.toString()));
            }
            if (files.size() > 1) {
                throw new RuntimeException("SelfResolvingDependency (%s) resolved too many files (%d) only 1 is expected".formatted(this.dependency.toString(), files.size()));
            }
            return files.iterator().next().toPath();
        }
        Object files = this.dependency;
        if (files instanceof FileCollectionDependency) {
            FileCollectionDependency fileCollectionDependency = (FileCollectionDependency)files;
            if ((files = fileCollectionDependency.getFiles().getFiles()).isEmpty()) {
                throw new RuntimeException("FileCollectionDependency (%s) resolved no files".formatted(fileCollectionDependency.toString()));
            }
            if (files.size() > 1) {
                throw new RuntimeException("FileCollectionDependency (%s) resolved too many files (%d) only 1 is expected".formatted(fileCollectionDependency.toString(), files.size()));
            }
            return ((File)files.iterator().next()).toPath();
        }
        return context.resolveDependency(this.dependency);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dependency.getGroup(), this.dependency.getName(), this.dependency.getVersion());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DependencyFileSpec) {
            DependencyFileSpec other = (DependencyFileSpec)obj;
            return other.dependency().contentEquals(this.dependency());
        }
        return false;
    }
}

