/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import net.fabricmc.loom.util.service.SharedService;
import net.fabricmc.loom.util.service.SharedServiceManager;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.tree.MemoryMappingTree;

public final class TinyMappingsService
implements SharedService {
    private final MemoryMappingTree mappingTree;

    public TinyMappingsService(Path tinyMappings) {
        try {
            this.mappingTree = new MemoryMappingTree();
            MappingReader.read((Path)tinyMappings, (MappingVisitor)this.mappingTree);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read mappings", e);
        }
    }

    public static synchronized TinyMappingsService create(SharedServiceManager serviceManager, Path tinyMappings) {
        return serviceManager.getOrCreateService("TinyMappingsService:" + String.valueOf(tinyMappings.toAbsolutePath()), () -> new TinyMappingsService(tinyMappings));
    }

    public MemoryMappingTree getMappingTree() {
        return this.mappingTree;
    }
}

