/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.processors;

import dev.architectury.loom.util.MappingOption;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.api.processor.ProcessorContext;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.processors.ContextImplHelper;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJar;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJarConfiguration;
import net.fabricmc.loom.util.LazyCloseable;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.tinyremapper.TinyRemapper;

public record ProcessorContextImpl(ConfigContext configContext, MinecraftJar minecraftJar) implements ProcessorContext
{
    @Override
    public MinecraftJarConfiguration getJarConfiguration() {
        return (MinecraftJarConfiguration)this.configContext.extension().getMinecraftJarConfiguration().get();
    }

    @Override
    public boolean isMerged() {
        return this.minecraftJar.isMerged();
    }

    @Override
    public boolean includesClient() {
        return this.minecraftJar.includesClient();
    }

    @Override
    public boolean includesServer() {
        return this.minecraftJar.includesServer();
    }

    @Override
    public LazyCloseable<TinyRemapper> createRemapper(MappingsNamespace from, MappingsNamespace to) {
        return ContextImplHelper.createRemapper(this.configContext, from, to);
    }

    @Override
    public MemoryMappingTree getMappings() {
        LoomGradleExtension extension = LoomGradleExtension.get(this.configContext().project());
        MappingOption mappingOption = MappingOption.forPlatform(extension);
        return extension.getMappingConfiguration().getMappingsService(this.configContext().serviceManager(), mappingOption).getMappingTree();
    }
}

