/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.processors;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.processor.MappingProcessorContext;
import net.fabricmc.loom.api.processor.MinecraftJarProcessor;
import net.fabricmc.loom.api.processor.ProcessorContext;
import net.fabricmc.loom.api.processor.SpecContext;
import net.fabricmc.loom.configuration.processors.JarProcessor;
import net.fabricmc.loom.configuration.processors.LegacyJarProcessorWrapper;
import net.fabricmc.loom.configuration.processors.SpecContextImpl;
import net.fabricmc.loom.util.Checksum;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.Project;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MinecraftJarProcessorManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinecraftJarProcessorManager.class);
    private final List<ProcessorEntry<?>> jarProcessors;

    private MinecraftJarProcessorManager(List<ProcessorEntry<?>> jarProcessors) {
        this.jarProcessors = Collections.unmodifiableList(jarProcessors);
    }

    @Nullable
    public static MinecraftJarProcessorManager create(Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        ArrayList processors = new ArrayList((Collection)extension.getMinecraftJarProcessors().get());
        for (JarProcessor legacyProcessor : (List)extension.getGameJarProcessors().get()) {
            processors.add((MinecraftJarProcessor)project.getObjects().newInstance(LegacyJarProcessorWrapper.class, new Object[]{legacyProcessor}));
        }
        return MinecraftJarProcessorManager.create(processors, SpecContextImpl.create(project));
    }

    @Nullable
    public static MinecraftJarProcessorManager create(List<MinecraftJarProcessor<?>> processors, SpecContext context) {
        ArrayList entries = new ArrayList();
        for (MinecraftJarProcessor<?> processor : processors) {
            LOGGER.debug("Building processor spec for {}", (Object)processor.getName());
            Object spec = processor.buildSpec(context);
            if (spec == null) continue;
            LOGGER.debug("Adding processor entry for {}", (Object)processor.getName());
            entries.add(new ProcessorEntry(processor, (MinecraftJarProcessor.Spec)spec));
        }
        if (entries.isEmpty()) {
            LOGGER.debug("No processor entries");
            return null;
        }
        return new MinecraftJarProcessorManager(entries);
    }

    private String getCacheValue() {
        return this.jarProcessors.stream().sorted(Comparator.comparing(ProcessorEntry::name)).map(ProcessorEntry::cacheValue).collect(Collectors.joining("::"));
    }

    private String getDebugString() {
        StringJoiner sj = new StringJoiner("\n");
        for (ProcessorEntry<?> jarProcessor : this.jarProcessors) {
            sj.add(jarProcessor.name() + ":");
            sj.add("\tHash: " + jarProcessor.hashCode());
            sj.add("\tStr: " + jarProcessor.cacheValue());
        }
        return sj.toString();
    }

    public String getJarHash() {
        return Checksum.sha1Hex(this.getCacheValue().getBytes(StandardCharsets.UTF_8)).substring(0, 10);
    }

    public boolean requiresProcessingJar(Path jar) {
        Objects.requireNonNull(jar);
        if (Files.notExists(jar, new LinkOption[0])) {
            LOGGER.debug("{} does not exist, generating", (Object)jar);
            return true;
        }
        return false;
    }

    public void processJar(Path jar, ProcessorContext context) throws IOException {
        for (ProcessorEntry<?> entry : this.jarProcessors) {
            try {
                entry.processJar(jar, context);
            }
            catch (IOException e) {
                throw new IOException("Failed to process jar when running jar processor: %s".formatted(entry.name()), e);
            }
        }
    }

    public boolean processMappings(MemoryMappingTree mappings, MappingProcessorContext context) {
        boolean transformed = false;
        for (ProcessorEntry<?> entry : this.jarProcessors) {
            if (!entry.processMappings(mappings, context)) continue;
            transformed = true;
        }
        return transformed;
    }

    record ProcessorEntry<S extends MinecraftJarProcessor.Spec>(S spec, MinecraftJarProcessor<S> processor, @Nullable MinecraftJarProcessor.MappingsProcessor<S> mappingsProcessor) {
        ProcessorEntry(MinecraftJarProcessor<?> processor, MinecraftJarProcessor.Spec spec) {
            this(Objects.requireNonNull(spec), processor, processor.processMappings());
        }

        private void processJar(Path jar, ProcessorContext context) throws IOException {
            this.processor().processJar(jar, this.spec, context);
        }

        private boolean processMappings(MemoryMappingTree mappings, MappingProcessorContext context) {
            if (this.mappingsProcessor() == null) {
                return false;
            }
            return this.mappingsProcessor().transform(mappings, this.spec, context);
        }

        private String name() {
            return this.processor.getName();
        }

        private String cacheValue() {
            return this.processor.getName() + ":" + this.spec.hashCode();
        }
    }
}

