/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.decompile;

import java.io.File;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJar;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.task.GenerateSourcesTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;

public abstract class DecompileConfiguration<T extends MappedMinecraftProvider> {
    static final String DEFAULT_DECOMPILER = "Vineflower";
    protected final Project project;
    protected final T minecraftProvider;
    protected final LoomGradleExtension extension;
    protected final MappingConfiguration mappingConfiguration;

    public DecompileConfiguration(Project project, T minecraftProvider) {
        this.project = project;
        this.minecraftProvider = minecraftProvider;
        this.extension = LoomGradleExtension.get(project);
        this.mappingConfiguration = this.extension.getMappingConfiguration();
    }

    public abstract String getTaskName(MinecraftJar.Type var1);

    public abstract void afterEvaluation();

    protected final void configureUnpick(GenerateSourcesTask task, File unpickOutputJar) {
        ConfigurationContainer configurations = task.getProject().getConfigurations();
        task.getUnpickDefinitions().set(this.mappingConfiguration.getUnpickDefinitionsFile());
        task.getUnpickOutputJar().set(unpickOutputJar);
        task.getUnpickConstantJar().setFrom((Iterable)configurations.getByName("mappingsConstants"));
        task.getUnpickClasspath().setFrom((Iterable)configurations.getByName("minecraftLibraries"));
        task.getUnpickClasspath().from(new Object[]{configurations.getByName("modCompileClasspathMapped")});
    }
}

