/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.accesstransformer;

import com.google.common.hash.Hashing;
import com.google.common.io.MoreFiles;
import dev.architectury.at.AccessTransformSet;
import dev.architectury.at.io.AccessTransformFormats;
import dev.architectury.loom.util.TempFiles;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.api.processor.MinecraftJarProcessor;
import net.fabricmc.loom.api.processor.ProcessorContext;
import net.fabricmc.loom.api.processor.SpecContext;
import net.fabricmc.loom.build.IntermediaryNamespaces;
import net.fabricmc.loom.configuration.accesstransformer.AccessTransformerEntry;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.util.DependencyDownloader;
import net.fabricmc.loom.util.ExceptionUtil;
import net.fabricmc.loom.util.ForgeToolExecutor;
import net.fabricmc.loom.util.LoomVersions;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.mappingio.tree.MappingTreeView;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.process.JavaExecSpec;
import org.jetbrains.annotations.Nullable;

public class AccessTransformerJarProcessor
implements MinecraftJarProcessor<Spec> {
    private static final Logger LOGGER = Logging.getLogger(AccessTransformerJarProcessor.class);
    private final String name;
    private final Project project;
    private final Iterable<File> localAccessTransformers;

    @Inject
    public AccessTransformerJarProcessor(String name, Project project, Iterable<File> localAccessTransformers) {
        this.name = name;
        this.project = project;
        this.localAccessTransformers = localAccessTransformers;
    }

    @Override
    @Nullable
    public Spec buildSpec(SpecContext context) {
        String hash;
        ArrayList<AccessTransformerEntry> entries = new ArrayList<AccessTransformerEntry>();
        for (File atFile : this.localAccessTransformers) {
            Path atPath = atFile.toPath();
            try {
                hash = MoreFiles.asByteSource((Path)atPath, (OpenOption[])new OpenOption[0]).hash(Hashing.sha256()).toString();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not compute AT hash", e);
            }
            entries.add(new AccessTransformerEntry.Standalone(atPath, hash));
        }
        for (FabricModJson localMod : context.localMods()) {
            byte[] bytes;
            try {
                bytes = localMod.getSource().read("META-INF/accesstransformer.cfg");
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                continue;
            }
            catch (IOException e) {
                throw ExceptionUtil.createDescriptiveWrapper(UncheckedIOException::new, "Could not read accesstransformer.cfg", e);
            }
            hash = Hashing.sha256().hashBytes(bytes).toString();
            entries.add(new AccessTransformerEntry.Mod(localMod, hash));
        }
        return !entries.isEmpty() ? new Spec(entries) : null;
    }

    @Override
    public void processJar(Path jar, Spec spec, ProcessorContext context) throws IOException {
        try (TempFiles tempFiles = new TempFiles();){
            LOGGER.lifecycle(":applying project access transformers");
            Path tempInput = tempFiles.file("input", ".jar");
            Files.copy(jar, tempInput, StandardCopyOption.REPLACE_EXISTING);
            Path atPath = this.mergeAndRemapAccessTransformers(context, spec.accessTransformers(), tempFiles);
            AccessTransformerJarProcessor.executeAt(this.project, tempInput, jar, args -> {
                args.add("--atFile");
                args.add(atPath.toAbsolutePath().toString());
            });
        }
        catch (IOException e) {
            throw ExceptionUtil.createDescriptiveWrapper(UncheckedIOException::new, "Could not access transform " + String.valueOf(jar.toAbsolutePath()), e);
        }
    }

    private Path mergeAndRemapAccessTransformers(ProcessorContext context, List<AccessTransformerEntry> accessTransformers, TempFiles tempFiles) throws IOException {
        AccessTransformSet accessTransformSet = AccessTransformSet.create();
        for (AccessTransformerEntry entry : accessTransformers) {
            try {
                Reader reader = entry.openReader();
                try {
                    accessTransformSet.merge(AccessTransformFormats.FML.read(reader));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new IOException("Could not read access transformer " + String.valueOf(entry), e);
            }
        }
        accessTransformSet = accessTransformSet.remap((MappingTreeView)context.getMappings(), IntermediaryNamespaces.intermediary(this.project), MappingsNamespace.NAMED.toString());
        Path accessTransformerPath = tempFiles.file("accesstransformer-merged", ".cfg");
        try {
            AccessTransformFormats.FML.write(accessTransformerPath, accessTransformSet);
        }
        catch (IOException e) {
            throw new IOException("Could not write access transformers to " + String.valueOf(accessTransformerPath), e);
        }
        return accessTransformerPath;
    }

    public String getName() {
        return this.name;
    }

    public static void executeAt(Project project, Path input, Path output, AccessTransformerConfiguration configuration) throws IOException {
        LoomVersions accessTransformer = AccessTransformerJarProcessor.chooseAccessTransformer(project);
        String mainClass = accessTransformer == LoomVersions.ACCESS_TRANSFORMERS_NEO ? "net.neoforged.accesstransformer.cli.TransformerProcessor" : "net.minecraftforge.accesstransformer.TransformerProcessor";
        FileCollection classpath = new DependencyDownloader(project).add(accessTransformer.mavenNotation()).add(LoomVersions.ASM.mavenNotation()).platform(LoomVersions.ACCESS_TRANSFORMERS_LOG4J_BOM.mavenNotation()).download();
        ArrayList<String> args = new ArrayList<String>();
        args.add("--inJar");
        args.add(input.toAbsolutePath().toString());
        args.add("--outJar");
        args.add(output.toAbsolutePath().toString());
        configuration.apply(args);
        ForgeToolExecutor.exec(project, (Action<? super JavaExecSpec>)((Action)spec -> {
            spec.getMainClass().set((Object)mainClass);
            spec.setArgs(args);
            spec.setClasspath(classpath);
        })).rethrowFailure().assertNormalExitValue();
    }

    private static LoomVersions chooseAccessTransformer(Project project) {
        MinecraftVersionMeta.JavaVersion javaVersion;
        boolean serverBundleMetadataPresent;
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        boolean bl = serverBundleMetadataPresent = extension.getMinecraftProvider().getServerBundleMetadata() != null;
        if (!serverBundleMetadataPresent) {
            return LoomVersions.ACCESS_TRANSFORMERS;
        }
        if (extension.isNeoForge() && (javaVersion = extension.getMinecraftProvider().getVersionInfo().javaVersion()) != null && javaVersion.majorVersion() >= 21) {
            return LoomVersions.ACCESS_TRANSFORMERS_NEO;
        }
        return LoomVersions.ACCESS_TRANSFORMERS_NEW;
    }

    public record Spec(List<AccessTransformerEntry> accessTransformers) implements MinecraftJarProcessor.Spec
    {
    }

    @FunctionalInterface
    public static interface AccessTransformerConfiguration {
        public void apply(List<String> var1) throws IOException;
    }
}

