/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration;

import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loom.configuration.DependencyInfo;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.gradle.SelfResolvingDependencyUtils;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.FileCollectionDependency;

public class FileDependencyInfo
extends DependencyInfo {
    protected final Map<String, File> classifierToFile = new HashMap<String, File>();
    protected final Set<File> resolvedFiles;
    protected final String group;
    protected final String name;
    protected final String version;

    FileDependencyInfo(Project project, FileCollectionDependency dependency, Configuration configuration) {
        this(project, (Dependency)dependency, configuration, dependency.getFiles().getFiles());
    }

    private FileDependencyInfo(Project project, Dependency dependency, Configuration configuration, Set<File> files) {
        super(project, dependency, configuration);
        this.resolvedFiles = files;
        switch (files.size()) {
            case 0: {
                throw new IllegalStateException("Empty dependency?");
            }
            case 1: {
                this.classifierToFile.put("", (File)Iterables.getOnlyElement(files));
                break;
            }
            default: {
                List sortedFiles = files.stream().sorted(Comparator.comparing(File::getName, Comparator.comparingInt(String::length))).collect(Collectors.toList());
                File shortest = (File)sortedFiles.remove(0);
                String shortestName = FilenameUtils.removeExtension((String)shortest.getName());
                for (File file : sortedFiles) {
                    if (file.getName().startsWith(shortestName)) continue;
                    throw new IllegalArgumentException("Unable to resolve classifiers for " + String.valueOf(this) + " (failed to sort " + String.valueOf(files) + ")");
                }
                this.classifierToFile.put("", shortest);
                int start = shortestName.length();
                for (File file : sortedFiles) {
                    String classifier = FilenameUtils.removeExtension((String)file.getName()).substring(start);
                    if (this.classifierToFile.put(classifier.charAt(0) == '-' ? classifier.substring(1) : classifier, file) == null) continue;
                    throw new InvalidUserDataException("Duplicate classifiers for " + String.valueOf(this) + " (\"" + file.getName().substring(start) + "\" in " + String.valueOf(files) + ")");
                }
            }
        }
        if (dependency.getGroup() != null && dependency.getVersion() != null) {
            this.group = dependency.getGroup();
            this.name = dependency.getName();
            this.version = dependency.getVersion();
        } else {
            this.group = "net.fabricmc.synthetic";
            File root = this.classifierToFile.get("");
            try {
                byte[] modJson;
                if ("jar".equals(FilenameUtils.getExtension((String)root.getName())) && (modJson = ZipUtils.unpackNullable(root.toPath(), "fabric.mod.json")) != null) {
                    json = (JsonObject)new Gson().fromJson(new String(modJson, StandardCharsets.UTF_8), JsonObject.class);
                    if (json == null || !json.has("id") || !json.has("version")) {
                        throw new IllegalArgumentException("Invalid Fabric mod jar: " + String.valueOf(root) + " (malformed json: " + String.valueOf(json) + ")");
                    }
                    this.name = json.has("name") ? json.get("name").getAsString() : json.get("id").getAsString();
                    this.version = json.get("version").getAsString();
                } else if ("jar".equals(FilenameUtils.getExtension((String)root.getName())) && (modJson = ZipUtils.unpackNullable(root.toPath(), "quilt.mod.json")) != null) {
                    json = (JsonObject)new Gson().fromJson(new String(modJson, StandardCharsets.UTF_8), JsonObject.class);
                    if (json == null || !json.has("quilt_loader")) {
                        throw new IllegalArgumentException("Invalid Quilt mod jar: " + String.valueOf(root) + " (malformed json: " + String.valueOf(json) + ")");
                    }
                    JsonObject loader = json.getAsJsonObject("quilt_loader");
                    if (!loader.has("id") || !loader.has("version")) {
                        throw new IllegalArgumentException("Invalid Quilt mod jar: " + String.valueOf(root) + " (malformed json: " + String.valueOf(json) + ")");
                    }
                    this.name = loader.has("metadata") && loader.get("metadata").getAsJsonObject().has("name") ? loader.get("metadata").getAsJsonObject().get("name").getAsString() : loader.get("id").getAsString();
                    this.version = loader.get("version").getAsString();
                } else {
                    this.name = FilenameUtils.removeExtension((String)root.getName());
                    this.version = "1.0";
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read input file: " + String.valueOf(root), e);
            }
        }
    }

    @Deprecated
    public static FileDependencyInfo createForDeprecatedSRD(Project project, Dependency dependency, Configuration configuration) {
        if (!SelfResolvingDependencyUtils.isExplicitSRD(dependency)) {
            throw new IllegalArgumentException("Dependency is a FileCollectionDependency");
        }
        return new FileDependencyInfo(project, dependency, configuration, SelfResolvingDependencyUtils.resolve(dependency));
    }

    @Override
    public String getResolvedVersion() {
        return this.version;
    }

    @Override
    public String getDepString() {
        return this.group + ":" + this.name + ":" + this.version;
    }

    @Override
    public String getResolvedDepString() {
        return this.getDepString();
    }

    @Override
    public Set<File> resolve() {
        return this.resolvedFiles;
    }
}

