/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.metadata;

import com.google.common.collect.ImmutableMap;
import dev.architectury.loom.metadata.ArchitecturyCommonJson;
import dev.architectury.loom.metadata.ErroringModMetadataFile;
import dev.architectury.loom.metadata.ModMetadataFile;
import dev.architectury.loom.metadata.ModsToml;
import dev.architectury.loom.metadata.QuiltModJson;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.Nullable;

public final class ModMetadataFiles {
    private static final Logger LOGGER = Logging.getLogger(ModMetadataFiles.class);
    private static final Map<String, Function<byte[], ModMetadataFile>> SINGLE_FILE_METADATA_TYPES = ImmutableMap.builder().put((Object)"quilt.mod.json", QuiltModJson::of).put((Object)"architectury.common.json", ArchitecturyCommonJson::of).put((Object)"META-INF/mods.toml", ModMetadataFiles.onError(ModsToml::of, "Could not load mods.toml", () -> new ErroringModMetadataFile("mods.toml"))).put((Object)"META-INF/neoforge.mods.toml", ModMetadataFiles.onError(ModsToml::of, "Could not load neoforge.mods.toml", () -> new ErroringModMetadataFile("neoforge.mods.toml"))).build();

    private static <A, B> Function<A, B> onError(Function<A, B> fn, String message, Supplier<B> onError) {
        return a -> {
            try {
                return fn.apply(a);
            }
            catch (Exception e) {
                LOGGER.info(message, (Throwable)e);
                return onError.get();
            }
        };
    }

    @Nullable
    public static ModMetadataFile fromJar(Path jar) throws IOException {
        for (String filePath : SINGLE_FILE_METADATA_TYPES.keySet()) {
            byte @Nullable [] bytes = ZipUtils.unpackNullable(jar, filePath);
            if (bytes == null) continue;
            return SINGLE_FILE_METADATA_TYPES.get(filePath).apply(bytes);
        }
        return null;
    }

    @Nullable
    public static ModMetadataFile fromDirectory(Path directory) throws IOException {
        for (String filePath : SINGLE_FILE_METADATA_TYPES.keySet()) {
            Path metadataPath = directory.resolve(filePath);
            if (!Files.exists(metadataPath, new LinkOption[0])) continue;
            return SINGLE_FILE_METADATA_TYPES.get(filePath).apply(Files.readAllBytes(metadataPath));
        }
        return null;
    }

    @Nullable
    public static ModMetadataFile fromSourceSets(SourceSet ... sourceSets) throws IOException {
        for (String filePath : SINGLE_FILE_METADATA_TYPES.keySet()) {
            @Nullable File file = SourceSetHelper.findFirstFileInResource(filePath, sourceSets);
            if (file == null) continue;
            return SINGLE_FILE_METADATA_TYPES.get(filePath).apply(Files.readAllBytes(file.toPath()));
        }
        return null;
    }
}

