/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.accesstransformer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.loom.util.fmj.FabricModJson;

public interface AccessTransformerEntry {
    public Reader openReader() throws IOException;

    public record Mod(FabricModJson fmj, String hash) implements AccessTransformerEntry
    {
        @Override
        public Reader openReader() throws IOException {
            byte[] bytes = this.fmj.getSource().read("META-INF/accesstransformer.cfg");
            return new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8);
        }

        @Override
        public String toString() {
            return this.fmj.toString();
        }
    }

    public record Standalone(Path path, String hash) implements AccessTransformerEntry
    {
        @Override
        public Reader openReader() throws IOException {
            return Files.newBufferedReader(this.path);
        }

        @Override
        public String toString() {
            return this.path.toString();
        }
    }
}

